if [ -e /tmp/bootselect ]; then
	SELECTED=$(cat /tmp/bootselect)

	if [ $SELECTED == "2" ]; then

		PLATFORM=freescale
		if [ `dd if=/dev/mmcblk0 bs=512 skip=1024 count=1 | grep -c "HW CONFIG"` == 1 ]; then
		        PLATFORM=ntx508
		fi
		[ $PLATFORM != freescale ] && rm -rf /dev/mmcblk1* && udevadm trigger &
		
                sleep 3

		# turn off boot animation
		killall on-animator.sh

		# stop led blinking		
                echo "ch 4" > /sys/devices/platform/pmic_light.1/lit
                echo "cur 0" > /sys/devices/platform/pmic_light.1/lit
                echo "dc 0" > /sys/devices/platform/pmic_light.1/lit

		echo "Launching koreader"
		# /mnt/onboard/.kobo/koreader/koreader.sh
		
		export LC_ALL="en_US.UTF-8"

		# we're always starting from our working directory
		cd /mnt/onboard/.kobo/koreader/

		# export trained OCR data directory
		export TESSDATA_PREFIX="data"

		# export dict directory
		export STARDICT_DATA_DIR="data/dict"

		# accept input ports for zsync plugin
		iptables -A INPUT -i wlan0 -p udp --dport 5670 -j ACCEPT
		iptables -A INPUT -i wlan0 -p tcp --dport 49152:49162 -j ACCEPT

		# finally call the launcher
		./reader.lua /mnt/onboard 2> crash.log
		

		PRODUCT=`/bin/kobo_config.sh`;
		[ $PRODUCT != trilogy ] && PREFIX=$PRODUCT-

		case $PRODUCT in
			kraken|phoenix)
				IMGPREFIX="kraken-"
				;; 
			dragon|dahlia)
				IMGPREFIX="dragon-"
				;;
			*)
				IMGPREFIX="pixie-"
				;;
		esac
		zcat /mnt/onboard/.kobo/advboot/images/$IMGPREFIX\poweroff.raw.gz | /usr/local/Kobo/pickel showpic
		
		/bin/busybox poweroff
	fi
fi
