<!--
	< This tool validated ePubs through the browser using https://github.com/IDPF/epubcheck command line tool
		It was created for people who dislike command-line tools >
    Copyright (C) <2014>  <http://odedta.com/>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
-->
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>EpubCheck Validator</title>
	
    <!-- Bootstrap -->
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">

    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
      <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
      <script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
    <![endif]-->
  </head>
  <body>
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="POST" enctype="multipart/form-data">
		<table class="table table-striped table-bordered">
			<caption><span class="label label-primary">ePub Validator</span></caption>
			<tr>
				<th>Modes</th>
				<th>Live folder view</th>
			</tr>
			<tr>
				<td>
					<ul>
						<li>opf - For single OPF file validation (<span class="glyphicon glyphicon-file"></span> opf)</li>
						<li>nav - For single 'Navigation Document' validation (<span class="glyphicon glyphicon-file"></span> ncx)</li>
						<li>mo - For single 'Media Overlays' validation (<span class="glyphicon glyphicon-file"></span> smil)</li>
						<li>xhtml - For single XHTML file validation (<span class="glyphicon glyphicon-file"></span> xhtml)</li>
						<li>svg - For single SVG file validation (<span class="glyphicon glyphicon-file"></span> svg)</li>
					</ul>
					<span class="glyphicon glyphicon-info-sign"></span> Modes will automatically be detected
				</td>
				<td>
					<?php
						echo '<div style="overflow-y:scroll;height:200px;">';
						$path = realpath($_SERVER['DOCUMENT_ROOT'] . '/epubcheck');
						foreach (new RecursiveIteratorIterator(new RecursiveDirectoryIterator($path)) as $filename)
						{
								echo $filename . '<br />';
						}
						echo '</div>';
					?>
				</td>
			</tr>
			<tr>
				<td colspan="2">
					<input type="file" name="file" title="Browse"/><button type="submit" class="btn btn-primary" name="submit" style="margin-left:2em;">Validate</button><span style="vertical-align:middle;margin-left:1em;">Upload must be smaller than 10MB</span>
				</td>
			</tr>
		</table>
	</form>
	<?php
		if(isset($_POST['submit']))
		{
			$allowedExts = array("epub", "html", "xhtml", "opf");
			$temp = explode(".", $_FILES["file"]["name"]);
			$extension = end($temp);
			if ((($_FILES["file"]["type"] == "text/html")
			|| ($_FILES["file"]["type"] == "application/xhtml+xml")
			|| ($_FILES["file"]["type"] == "application/octet-stream")
			|| ($_FILES["file"]["type"] == "application/epub+zip")
			&& ($_FILES["file"]["size"] < 10000)
			&& in_array($extension, $allowedExts)))
			{
				switch($_FILES['file']['error'])
				{
					case 0:
						move_uploaded_file($_FILES["file"]["tmp_name"],"upload/" . $_FILES["file"]["name"]);
						set_time_limit(0);
						$length = 20;
						$randomString = substr(str_shuffle("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, $length); // Give a random filename to the epubcheck output xml
						$path_to_xml = 'upload/' . $randomString . '.xml';
						$path_to_file = 'upload/' . $_FILES["file"]["name"];
						$extension = explode('.',$path_to_file); // #extension[1] is the uploaded file extension
						if(strcmp($extension[1],'svg') == 0)
							$args = '-mode svg';
						if(strcmp($extension[1],'smil') == 0)
							$args = '-mode mo';
						if(strcmp($extension[1],'ncx') == 0)
							$args = '-mode nav';
						if(strcmp($extension[1],'opf') == 0)
							$args = '-mode opf';
						if(strcmp($extension[1],'epub') == 0)
							$args = '';
						$command = 'java -jar epubcheck-3.0.1/epubcheck-3.0.1.jar ' . $path_to_file . ' -out ' . $path_to_xml . ' ' . $args; //Passing the Argument to the Jar file.
						exec($command,$executeCommmand);
						$xml = simplexml_load_file($path_to_xml);
						if(strcmp($xml->repInfo->status,'Not well-formed') == 0) // If errors found print them
						{
							echo '<table class="table table-striped table-bordered">';
							echo '<tr>';
							echo '<th>Application</th>';
							echo '<th>Status</th>';
							echo '<th>File name</th>';
							echo '<th>Size</th>';
							echo '<th>Version</th>';
							echo '</tr>';
							echo '<tr>';
							echo '<td>' . $xml->repInfo->format . '</td>';
							echo '<td>' . $xml->repInfo->status . '</td>';
							echo '<td>' . $xml->repInfo['uri'] . '</td>';
							echo '<td>' . round($_FILES["file"]["size"] / 1024) . ' KB</td>';
							echo '<td>' . $xml->repInfo->version . '</td>';
							echo '</tr>';
							echo '</table>';
							echo '<div class="alert alert-danger"><b>Oh no!</b> your file has errors.</div>';
							echo '<table class="table table-striped table-bordered">';
							echo '<tr>';
							echo '<th>Type</th>';
							echo '<th>File</th>';
							echo '<th>Line</th>';
							echo '<th>Message</th>';
							echo '</tr>';
							foreach($xml->repInfo->messages->message as $value)
							{
								$exploded_value = explode(':',$value); // Decomposing main string to separate messages
								$start_of_line_str = strpos($exploded_value[1],'('); // Extracting message of line number
								$start_of_line_str++;
								$end_of_line_str = strpos($exploded_value[1],')');
								$line = substr($exploded_value[1],$start_of_line_str,$end_of_line_str-$start_of_line_str);
								if(strpos($exploded_value[1],'(') != NULL)
									$file_name = substr($exploded_value[1],2,strpos($exploded_value[1],'(')-2);
								else
									$file_name = substr($exploded_value[1],2);
								echo '<tr>';
								echo '<td>' . $exploded_value[0] . '</td>';
								echo '<td>' . $file_name . '</td>';
								echo '<td>' . $line . '</td>';
								if(isset($exploded_value[3]))
									echo '<td>' . $exploded_value[2] . ': ' . $exploded_value[3] . '</td>';
								else
									echo '<td>' . $exploded_value[2] . ' ' . '</td>';
								echo '</tr>';
							}
							echo '</table>';
						}
						else
						{
							echo '<table class="table table-striped table-bordered">';
							echo '<tr>';
							echo '<th>Application</th>';
							echo '<th>Status</th>';
							echo '<th>File name</th>';
							echo '<th>Size</th>';
							echo '<th>Version</th>';
							echo '</tr>';
							echo '<tr>';
							echo '<td>' . $xml->repInfo->format . '</td>';
							echo '<td>' . $xml->repInfo->status . '</td>';
							echo '<td>' . $xml->repInfo['uri'] . '</td>';
							echo '<td>' . round($_FILES["file"]["size"] / 1024) . ' KB</td>';
							echo '<td>' . $xml->repInfo->version . '</td>';
							echo '</tr>';
							echo '</table>';
							echo '<div class="alert alert-success"><b>Congratulations! No errors or warnings detected.</b></div>';
						}
						if(unlink($path_to_xml) && unlink($path_to_file))
							echo '<div class="alert alert-info">File deleted from server successfully.</div>';
						break; 
					case 1: 
						echo '<div class="alert alert-error">The uploaded file exceeds the upload_max_filesize directive in php.ini</div>'; 
						break; 
					case 2: 
						echo '<div class="alert alert-error">The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form.</div>'; 
						break; 
					case 3: 
						echo '<div class="alert alert-error">The uploaded file was only partially uploaded.</div>'; 
						break; 
					case 4: 
						echo '<div class="alert alert-error">No file was uploaded.</div>'; 
						break; 
					case 5: 
						echo '<div class="alert alert-error">Missing a temporary folder. Introduced in PHP 4.3.10 and PHP 5.0.3.</div>';  
						break;
					case 6: 
						echo '<div class="alert alert-error">Failed to write file to disk. Introduced in PHP 5.1.0.</div>';  
						break;
					case 7: 
						echo '<div class="alert alert-error">A PHP extension stopped the file upload. PHP does not provide a way to ascertain which extension caused the file upload to stop; examining the list of loaded extensions with phpinfo() may help. Introduced in PHP 5.2.0.</div>';  
						break;
					default: 
						echo '<div class="alert alert-error">Unknown upload error, please try again.</div>'; 
						break; 
				}
			}
			else
			{
				echo '<div class="alert alert-error">This file is not allowed for upload</div>';
			}
		}
	?>
	<hr />
	<div id="footer">
		Click <a href="http://odedta.com/projects/epubcheck/epubcheck.zip">here</a> to download this tool
		 | Created by <a href="http://odedta.com/" target="_blank">odedta.com</a>
	</div>
    <!-- jQuery (necessary for Bootstrap's JavaScript plugins) -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.0/jquery.min.js"></script>
    <!-- Include all compiled plugins (below), or include individual files as needed -->
    <script src="js/bootstrap.min.js"></script>
    <script src="js/bootstrap.file-input.js"></script>
	<script>
		$( document ).ready(function() {
			$('input[type=file]').bootstrapFileInput();
			$('.file-inputs').bootstrapFileInput();
		});
	</script>
  </body>
</html>