#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
from __future__ import (unicode_literals, division, absolute_import,
                        print_function)

__license__   = 'GPL v3'
__copyright__ = '2011, Grant Drake <grant.drake@gmail.com>, expanded 2014 by Robert L. Hood <bob@thehandbasket.com> and Leigh Parry <leighparry@blueyonder.co.uk>'
__docformat__ = 'restructuredtext en'

# The class that all Interface Action plugin wrappers must inherit from
from calibre.customize import InterfaceActionBase

class ActionModifyEpub(InterfaceActionBase):
    '''
    This class is a simple wrapper that provides information about the actual
    plugin class. The actual interface plugin class is called InterfacePlugin
    and is defined in the ui.py file, as specified in the actual_plugin field
    below.

    The reason for having two classes is that it allows the command line
    calibre utilities to run without needing to load the GUI libraries.
    '''
    name                    = 'Modify ePub'
    description             = 'Apply cleanup tasks and updates to an ePub without doing a conversion'
    supported_platforms     = ['windows', 'osx', 'linux']
    author                  = 'Grant Drake, with additions by Robert L. Hood and Leigh Parry'
    version                 = (1, 3, 12)
    minimum_calibre_version = (0, 8, 53)

    #: This field defines the GUI plugin class that contains all the code
    #: that actually does something. Its format is module_path:class_name
    #: The specified class must be defined in the specified module.
    actual_plugin           = 'calibre_plugins.modify_epub.action:ModifyEpubAction'
