#!/usr/bin/env python
# -*- coding: utf-8 -*-
# vim:ts=4:sw=4:softtabstop=4:smarttab:expandtab
from __future__ import (unicode_literals, division, absolute_import,
                        print_function)

# target script

import os, sys
import ConfigParser, inspect, ntpath, codecs, zipfile
from contextlib import contextmanager
from Tkinter import *
import Tkconstants, tkFileDialog


PROGNAME = 'Kindle Import'
SCRIPT_DIR = os.path.normpath(os.path.dirname(os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))))
CONFIGFILE = os.path.join(SCRIPT_DIR, '{0}.ini'.format(PROGNAME.replace(' ', '')))


@contextmanager
def make_temp_directory():
    import tempfile, shutil
    temp_dir = tempfile.mkdtemp()
    yield temp_dir
    shutil.rmtree(temp_dir)



def getPrefs():
    startFilePath = os.path.expanduser('~')
    try:
        config = ConfigParser.RawConfigParser()
        with codecs.open(CONFIGFILE, 'r', 'utf-8') as f:
                config.readfp(f)
    except:
        return startFilePath
    if config.has_option('Defaults', 'use_file_path'):
        startFilePath = config.get('Defaults', 'use_file_path').decode('unicode_escape')  
    return startFilePath

def setPrefs(inpath):
    config = ConfigParser.RawConfigParser()
    config.add_section('Defaults')
    config.set('Defaults', 'use_file_path', os.path.dirname(inpath).encode('unicode_escape'))
    try:
        with codecs.open(CONFIGFILE, 'w', 'utf-8') as f:
            config.write(f)
    except:
        pass
    else:
        return
    
def isEPUB(zip):
    if not zipfile.is_zipfile(zip):
        return False
    with zipfile.ZipFile(zip, 'r') as archive:
        if archive.infolist()[0].filename != 'mimetype':
            return False
        elif archive.read('mimetype') == 'application/epub+zip':
            return True
        else:
            return False

def fileChooser():
    localRoot = Tk()
    localRoot.withdraw()
    file_opt = {}
    file_opt['parent'] = None
    file_opt['title']= 'Select Kindlebook file'
    file_opt['defaultextension'] = '.azw3'
    file_opt['initialdir'] = getPrefs()
    file_opt['multiple'] = False
    file_opt['filetypes'] = [('Kindlebooks', ('.azw', '.azw3', '.prc', '.mobi'))]
    localRoot.quit()
    return tkFileDialog.askopenfilename(**file_opt)

def run(bk):
    
    print ('Entering KindleUnpack input plugin\'s run() routine')
    
    inpath = fileChooser()
    if inpath == '' or not os.path.exists(inpath):
        raise Exception('No input file selected!')

    print ('Path to Kindlebook {0}'.format(inpath))
    from mobi_stuff import mobiProcessor, topaz
    if topaz(inpath):
        raise Exception('Kindlebook is in Topaz format: can\'t open!')

    mobionly = False
    mp = mobiProcessor(inpath)
    if mp.isEncrypted:
        setPrefs(inpath)
        raise Exception('Kindlebook is encrypted: can\'t open!')
    if mp.isPrintReplica:
        setPrefs(inpath)
        raise Exception('Kindlebook is a Print Replica: can\'t open!')
    if not mp.isComboFile and not mp.hasKF8:
        mobionly = True
        
    setPrefs(inpath)
    with make_temp_directory() as temp_dir:
        if not mobionly:
            epub, src = mp.unpackEPUB(temp_dir)
            if src is not None and isEPUB(src):
                print ('Using included kindlegen sources.')
                epub = src
        else:
            from quickepub import QuickEpub
            mobidir, mobi_html, mobi_opf, mobiBaseName = mp.unpackMOBI(temp_dir)
            qe = QuickEpub(mobidir, mobi_html, mobi_opf, mobiBaseName)
            epub = qe.makeEPUB()
        print ('Path to epub or src {0}'.format(epub))
        with open(epub,'rb')as fp:
            data = fp.read()
        bk.addotherfile(os.path.basename(epub), data)    
 
    return 0
 
def main():
    print ('I reached main when I should not have\n')
    return -1
    
if __name__ == "__main__":
    sys.exit(main())

