import re
import subprocess
import fileinput

# Usage: python dlimp.py YourCSVFileName.txt
# WARNING: this script assumes that you have added a Calibre custom column for "read" to indicate if a book has been read
# WARNING: this script also assumes that you have exported a tab delimited list, and the following columns:

# First line of Delicious Library Export is list of column names.  Add [#] so that you can map your Calibre columns
# creator[0],dewey decimal[1],e.a.n.[2],genres[3],i.s.b.n.[4],item type[5],language[6],library of congress[7],location[8],net rating[9],notes[10],played / read[11],rating[12],title[13],url[14]

# You may need to specify the path to the calibre command line applications; then again, you may not.
calibrePath = ''
calibrePath = '/Volumes/Macintosh\ HD/Applications/calibre.app/Contents/MacOS/'

def is_number(s):
    try:
        float(s)
        return True
    except ValueError:
        return False

for line in fileinput.input():
  currentline = line.split("\t")

  # map from Delicious Library (or other CSV) columns to Calibre columns
  authors = currentline[0].replace('"', '')
  title = currentline[13]
  location = currentline[8]
  rating = currentline[12]
  isbn = currentline[4]
  tags = currentline[3].replace('"', '')
  read = currentline[11]
  language = "English"

  print "Title: " + title
  print "Authors: " + authors
  print "Rating: " + rating
  print "ISBN: " + isbn
  print "Tags: " + tags
  print "Location: " + location
  print "Language: " + language

  #isbn cannot be null
  if isbn == '': 
    isbn = "0000000000000"

  # rating has to be a number. 
  # this deals with first line of Delicious Library export which is column names
  # WARNING: this may also skip ALL lines if the mapping from exported columns to Calibre columns is not done correctly
  if not is_number(rating) :
    continue

  execute = calibrePath + 'calibredb add -e -a "' + authors + '" -t "' + title + '" -i ' + isbn
  outp = subprocess.check_output(execute, shell=True)
  paragraphs = outp.split("\n")
  record_id = re.findall('\d+', paragraphs[1])
  id = record_id[0]

  # I concatenate physical location with tags
  if location != '' : tags = tags + ', location: ' + location
  if read == 1 : 
    read = "true"
  else :
    read = "false"

  execute = calibrePath + 'calibredb set_metadata'
  if rating != '' : execute = execute + ' --field "rating:' + rating + '"'
  if tags != '' : execute = execute + ' --field "tags:' + tags + '"'
  if read != '' : execute = execute + ' --field "#read:' + read + '"'
  if language != '' : execute = execute + ' --field "languages:' + language + '"'
  execute = execute + ' ' + id
  outp = subprocess.check_output(execute, shell=True)
