#!/bin/sh
OTA=com.lab126.blanket.ota

progress()
{
	lipc-send-event $OTA otaSplashProgress -i $1
	local x=48
	local y=11
	eips 0 $y "                                                ";
	eips $((($x - $(expr length "$2")) / 2)) $y "$2"
	sleep 2
}

fail()
{
	lipc-send-event $OTA otaSplashError -s "${1}"
	sleep 10
	exit 1;
}


progress 20 "Mounting main partition r/w"
mntroot rw || fail "Unable to mount main partition r/w".

progress 30 "Removing upstart config"
rm -f /etc/upstart/acxe.conf || fail "Unable to remove upstart config"

progress 50 "Removing keystore & policies"
rm -rf /opt/amazon/ebook/security.acxe || fail "Unable to remove keystore & policies"

progress 60 "Removing acxe dir"
rm -rf /mnt/us/acxe

progress 70 "Cleaning appreg.db"
cat <<EOT | sqlite3 /var/local/appreg.db
delete from properties where handlerId like '%translation%';
delete from handlerIds where handlerId like '%translation%';
delete from associations where handlerId like '%translation%';
delete from properties where name like '%translator%';
EOT

progress 80 "Cleaning /system/acw"
rm -f /mnt/us/system/acw/*

progress 100 "Uninstallation complete."
