#!/bin/sh

OTA=com.lab126.blanket.ota

progress()
{
	lipc-send-event $OTA otaSplashProgress -i $1
	local x=48
	local y=11
	eips 0 $y "                                                ";
	eips $((($x - $(expr length "$2")) / 2)) $y "$2"
	sleep 2
}

fail()
{
	lipc-send-event $OTA otaSplashError -s "${1}"
	sleep 10
	exit 1;
}

progress 20 "Mounting main partition r/w"
mntroot rw || fail "Unable to mount main partition r/w".

progress 40 "Copying upstart config to main partition"
cp acxe.conf /etc/upstart/ || fail "Unable to copy upstart config"

progress 60 "Copying keystore and policies to main partition"
[ -d /opt/amazon/ebook/security.acxe ] || mkdir /opt/amazon/ebook/security.acxe || fail "Unable to create security.acxe dir"
cp defaultPolicies.json /opt/amazon/ebook/security.acxe/ || fail "Unable to copy policies"
cp keystore_mesquite.xml /opt/amazon/ebook/security.acxe/ || fail "Unable to copy keystore"

if [ ! -d /mnt/base-us/acxe ]
then
    progress 80 "Creating acxe dir in userstore"
    mkdir /mnt/us/acxe
fi

progress 100 "Installation complete."
