#! /bin/bash

source config

PKGNAME="$HACKNAME"
PKGVER="${VERSION}"

# Prepare our files for this specific kindle model...
ARCH=${PKGNAME}_${PKGVER}

# Build install update
cp -f install.sh run.ffs
./kindletool create ota2 --device kindle5 run.ffs acxe.conf keystore_mesquite.xml defaultPolicies.json Update_${ARCH}_install.bin

# Build uninstall update
cp -f uninstall.sh run.ffs
./kindletool create ota2 --device kindle5 run.ffs Update_${ARCH}_uninstall.bin

rm -f run.ffs

[ -f ../${PKGNAME}_${PKGVER}.zip ] && rm -f ../${PKGNAME}_${PKGVER}.zip
zip ../${PKGNAME}_${PKGVER}.zip *.bin readme.txt
rm -f *.bin

tar cvzf ../${PKGNAME}_${PKGVER}_src.tar.gz *
