#!/usr/bin/python3

import os
import shutil
import atexit
import kobo_package_tool
import kobo_common
kc = kobo_common


def moveLogs():
    if not kc.isLogDirEmpty(kc.installer_log_path) and not kc.usbIn():
        flash_log_path = os.path.join(kc.flash_path, kc.installer_name)
        errstr = 'Failed to move log files to flash partition'
        
        try:
            os.mkdir(flash_log_path)
            log_err_tpl = 'cp -r {0}/* {1}'
            log_err = os.system(log_err_tpl.format(kc.installer_log_path, 
                                                   flash_log_path))
        except FileExistsError:
            pass
        except OSError:
            logger.warning(errstr, exc_info=True)
            log_err = 0
        
        if log_err:
            logger.warning(errstr)


def main():
    log_path = os.path.join(kc.installer_log_path, 'kobo_installer.log')
    logger = kc.KoboDebugger(log_path).logger
    atexit.register(moveLogs)
    
    try:
        shutil.rmtree(kc.installer_log_path)
    except FileNotFoundError:
        logger.warning('No directory "{0}"'.format(kc.installer_log_path))
    
    os.mkdir(kc.installer_log_path)
    
    with open(kc.reboot_path, mode='w') as rebootf:
        rebootf.write('0')
    
    # extract files in sideloaded packages
    kobo_package_tool.main()
    
    pack_list_temp = os.listdir(kc.installer_scripts_path)
    pack_list = (elem for elem in pack_list_temp 
                 if elem.endswith(('.py', '.sh')))
    
    for script_name in pack_list:
        script_path = os.path.join(kc.installer_scripts_path, script_name)
        pack_name, pack_ext = os.path.splitext(script_name)
        
        if pack_ext == '.sh':
            interp = 'sh'
            script_log_path = os.path.join(kc.installer_log_path, 
                                           pack_name + '.log')
            log_redir = '2>{0}'.format(script_log_path)
        elif pack_ext == '.py':
            interp = 'python3'
            log_redir = ''
        
        commandstr = '{0} {1} {2}'.format(interp, script_path, log_redir)
        err_str = 'Failed to run script "{0}"'.format(script_path)
        script_err = False
        
        try:
            print_err = os.system(commandstr)
        except OSError:
            logger.exception(err_str, exc_info=True)
            script_err = True
            print_err = 0
        
        if print_err:
            logger.error(err_str)
            script_err = True
        
        if script_err:
            os.remove(script_path)
    
    with open(kc.reboot_path) as rebootf:
        reboot = rebootf.read()
    
    if reboot == "1":
        print('Rebooting...')
        
        with open(kc.reboot_path, mode='w') as rebootf:
            rebootf.write('0')
        
        os.sync()
        os.sync() # kobo devs do it twice. Don't ask me why.
        os.system('reboot')


if __name__ == '__main__':
    main()

