#!/usr/bin/python3

import os
import re
import sqlite3
import kobo_common
kc = kobo_common
### Platform-independent, but more difficult to use than sys.sytem('tar')
#import tarfile

def main():
    log_path = os.path.join(kc.installer_log_path, 'kobo_package_tool.log')
    logger = kc.KoboDebugger(log_path).logger
    
    def compareVer(candidate_ver, inst_ver):
        # return 0 if identical, 1 if candidate is greater, -1 if lesser
        
        clist = candidate_ver.split('.')
        ilist = inst_ver.split('.')
        
        for i in range(min(len(clist), len(ilist))):
            if clist[i] > ilist[i]:
                return 1
            elif clist[i] < ilist[i]:
                return -1
        
        return 0
    
    def getVer(mydict):
        return '{0}-{1}'.format(mydict['ver'], mydict['subver'])
    
    vernumre = r'\d{1,3}'
    versionre = r'(' + vernumre + '\.){0,2}' + vernumre
    reboot_pack = False
    reboot = False
    fpath = ''

    files = os.listdir(kc.pack_path)

    files.append('') #because of continue

    try:
        with sqlite3.connect(kc.pack_db_path) as dbconn:
            dbconn.row_factory = sqlite3.Row
            
            for fname in files:
                #remove previous pack. Because of continue
                if fpath:
                    try:
                        if os.access(fpath, os.F_OK):
                            os.remove(fpath)
                            
                            if os.access(fpath, os.F_OK):
                                reboot_pack = False
                    except OSError:
                        logger.warning('Failed to remove package ' + fpath)
                        reboot_pack = False
                    
                    if reboot_pack:
                        reboot = True
                
                #Because of continue too. See files list.
                if not fname:
                    continue
                
                reboot_pack = False
                fpath = os.path.join(kc.pack_path, fname)
                
                mf = re.match(r'(?P<name>.{1,255})_(?P<ver>' + versionre + 
                              r')(-(?P<subver>' + versionre + 
                              '))?(\.tar)?\.(xz|gz)', 
                              fname)
                
                if not mf:
                    err_tpl = '"{0}" is not a canonical package name'
                    logger.error(err_tpl.format(fname))
                    continue
                
                fdict = mf.groupdict()
                
                prev_pack = fdict['name']
                
                if not fdict['subver']:
                    fdict['subver'] = '0'
                
                toskip = False
                
                for elem in fdict.values():
                    if elem != elem.strip():
                        err_tpl = 'Whitespaces in package name "{0}"'
                        logger.error(err_tpl.format(fname))
                        toskip = True
                        break
                
                if toskip:
                    continue
                
                cur = dbconn.cursor()
                
                try:
                    cur.execute('''
select name as name, ver as ver, subver as subver from pack where name = ?;
                                ''', (fdict['name'], ))
                except sqlite3.Error:
                    errstr = ('Failed to get data from package database' + 
                              kc.pack_db_path)
                    logger.exception(errstr)
                    break
                
                packrow = cur.fetchone()
                
                dbmod = ''
                
                if not packrow:
                    dbmod = 'toins'
                else:
                    ver_comparison = compareVer(fdict['ver'], packrow['ver'])
                    
                    if ver_comparison == 0:
                        ver_comparison = compareVer(fdict['subver'], 
                                                    packrow['subver'])
                    
                    if ver_comparison > -1:
                        dbmod = 'toupd'
                    else:
                        err_tpl = ('Installation of package "{0}" version ' + 
                                   '{1} aborted, version {2} already installed')
                        logger.error(err_tpl.format(fdict['name'], 
                                                    getVer(fdict), 
                                                    getVer(packrow)))
                
                if dbmod:
                    ### Don't work if you have to overwrite existing files
                    #with tarfile.open(name=fpath, mode='r', errorlevel=1) \
                    #as tarfd:
                    #    tarfd.extractall('/')
                    
                    tar_err_str = 'Untar of "{0}" failed'.format(fpath)
                    
                    try:
                        # use subprocess instead for a better debug
                        # check if it works on arm
                        tar_err = os.system('tar -C / -xf "{0}"'.format(fpath))
                    except OSError:
                        logger.exception(tar_err_str)
                        tar_err = 0
                    
                    if tar_err:
                        logger.error(tar_err_str)
                        continue
                    else:
                        reboot_pack = True
                
                if dbmod == 'toupd':
                    try:
                        with dbconn:
                            dbconn.execute('''
update pack set name=:name, ver=:ver, subver=:subver where name=:name;
                                           ''', fdict)
                    except sqlite3.Error:
                        errstr = ('Failed to update info in package db ' + 
                                  'with data ' + repr(fdict))
                        logger.error(errstr)
                        continue
                elif dbmod == 'toins':
                    try:
                        with dbconn:
                            dbconn.execute('''
insert into pack (name, ver, subver) values (:name, :ver, :subver);
                                           ''', fdict)
                    except sqlite3.Error:
                        errstr = ('Failed to insert data in package db ' + 
                                 'using ' + repr(fdict))
                        logger.error(errstr)
                        continue
            
            dbconn.commit()
    except sqlite3.Warning:
        logger.warning('Problem with package ' + 
                       'database "{0}"'.format(kc.pack_db_path), 
                       exc_info=True)
    
    if reboot:
        with open(kc.reboot_path, mode='w') as rebootf:
            rebootf.write('1')


if __name__ == '__main__':
    main()

