#!/usr/bin/env python
# -*- coding: utf-8 -*-
# vim:ts=4:sw=4:softtabstop=4:smarttab:expandtab

# target script

import sys

def test(condition, msg):
    if condition:
        print msg, " Passed"
    else:
        print msg, " Failed"
        raise Exception(msg + ' Failed')

def run(bk):
    print "Entered Target Script run() routine"

    for book_href in bk.other_iter():
        print book_href
    test(True, "other iterator")

    data = '<html>\n<head>\n<title>Hello</title>\n</head>\n<body><p>Hello World</p>\n</body>\n</html>\n'
    book_href = "OEBPS/Text/my_test.html"
    bk.addotherfile(book_href, data)
    test(book_href in bk._w.id_to_filepath.keys(), "adding a file")
    print bk._w.added
    test(book_href in bk._w.added, "checking it was properly added")

    data = '<html>\n<head>\n<title>Hello</title>\n</head>\n<body><p>Hello World Too</p>\n</body>\n</html>\n'
    book_href = "OEBPS/Text/my_test2.html"
    bk.addotherfile(book_href, data)
    test(book_href in bk._w.id_to_filepath.keys(), "adding a second file")
    test(book_href in bk._w.added, "checking it was properly added")

    bk.deleteotherfile(book_href)
    test(book_href not in bk._w.added, "deleting a file")
    
    print "target script completed and returning with 0"
    
    return 0
 
def main():
    print "I reached main when I should not have\n"
    return -1
    
if __name__ == "__main__":
    sys.exit(main())

