#!/usr/bin/env python
# -*- coding: utf-8 -*-
# vim:ts=4:sw=4:softtabstop=4:smarttab:expandtab

# target script

import sys

def test(condition, msg):
    if condition:
        print msg, " Passed"
    else:
        print msg, " Failed"
        raise Exception(msg + ' Failed')

def run(bk):
    print "Entered Target Script run() routine"

    lastid = None

    # test iterators
    for (id, href) in bk.text_iter():
        print id, href
        lastid = id
    test(True, "text iterator")

    for (id, href) in bk.css_iter():
        print id, href
    test(True, "css iterator")

    for (id, href, mime) in bk.image_iter():
        print id, href, mime
    test(True, "image iterator")

    for (id, href, mime) in bk.font_iter():
        print id, href, mime
    test(True, "font iterator")

    for (id, href, mime) in bk.manifest_iter():
        print id, href, mime
    test(True, "manifest iterator")

    for (id, linear, href) in bk.spine_iter():
        print id, linear, href
    test(True, "spine iterator")

    for (type, title, href, id) in bk.guide_iter():
        print type, title, href, id
    test(True, "guide iterator")

    for (id, href, mime) in bk.media_iter():
        print id, href, mime
    test(True, "media iterator")

    for book_href in bk.other_iter():
        print book_href
    test(True, "other iterator")

    # reading a book file
    stuff = bk.readfile(lastid)
    test(stuff is not None, "reading a file")

    # Sigil does not write mimetype file in its root tmp folder
    # so to avoid failure of test I commented it out (varlog)
    # reading a non-manifest book file
    #stuff = bk.readfile('mimetype')
    #print stuff
    #test(stuff is not None, "reading a non-manifest file")
    
    # writing a book file
    bk.writefile(lastid, stuff)
    test(lastid in bk._w.modified.keys(), "writing a file")

    data = '<html>\n<head>\n<title>Hello</title>\n</head>\n<body><p>Hello World</p>\n</body>\n</html>\n'
    basename = "my_test.html"
    mt = "application/xhtml+xml"
    uid1 = 'add1'
    bk.addfile(uid1, basename, data, mt)
    test(uid1 in bk._w.id_to_mime.keys(), "adding a file")
    bid = bk.basename_to_id(basename)
    test(bid == uid1, "mapping bassename to manifest id")

    data = '<html>\n<head>\n<title>Hello2</title>\n</head>\n<body><p>Hello World2</p>\n</body>\n</html>\n'
    basename = "my_test2.html"
    uid2 = 'add2'
    bk.addfile(uid2, basename, data)
    test(uid2 in bk._w.added, "writing a second file")

    bk.deletefile(uid2)
    test(uid2 not in bk._w.added, "deleting a file")
    
    # test the stream based QuickParser by parsing metadataxml to look for cover id
    print bk.getmetadataxml()

    ps = bk.qp
    ps.setContent(bk.getmetadataxml())
    res = []
    coverid = None
    for text, tagprefix, tagname, tagtype, tagattr in ps.parse_iter():
        # print tagprefix, tagname, tagtype, tagattr
        if text is not None:
            # print text
            res.append(text)
        else:
            # print tagprefix, tagname, tagtype, tagattr
            res.append(ps.tag_info_to_xml(tagname, tagtype, tagattr))
            if tagname == "meta" and tagattr.get("name",'') == "cover":
                coverid = tagattr["content"]
    print "".join(res)
    test(True, "QuickXHTMLParser")

    # test convenience mappings
    print "coverid is: ", coverid, bk.id_to_href(coverid), bk.id_to_mime(coverid)
    test(True, "mappings")

    # test copying entire book to new directory
    # bk.copy_book_contents_to("/Users/kbhend/Desktop/book_copy")
    # test(True, "book copying")
    
    return 0
 
def main():
    print "I reached main when I should not have\n"
    return -1
    
if __name__ == "__main__":
    sys.exit(main())

