#!/usr/bin/env python
# -*- coding: utf-8 -*-
# vim:ts=4:sw=4:softtabstop=4:smarttab:expandtab

import sys, os
import tempfile, shutil

import new_uuid

def run(bk):
    # get the opf data from the bookcontainer interace
    opfdata = bk.get_opf()

    # create a temporary directory store it there as new_uuid wants a path
    mydir = tempfile.mkdtemp()
    opfpath = os.path.join(mydir, 'content.opf')
    file(opfpath,'wb').write(opfdata)

    # now invoke new_uuid's main routine and get its return value
    argv = ['new_uuid.py', opfpath]
    rv = new_uuid.main(argv)

    # if it failed raise failed exception
    if rv is not None and rv != 0:
        shutil.rmtree(mydir)
        raise Exception("new_uuid failed")

    # success so grab revised metadata from temp content.opf
    # and set it via the interface
    if rv == 0:
        # extract just the new metadata and set it
        opfdata = file(opfpath,'rb').read()
        ms = opfdata.find('<metadata')
        me = opfdata.find('</metadata>')
        if ms > -1 and me > -1:
            newmetadata = opfdata[ms:me+11] + '\n'
            bk.setmetadataxml(newmetadata)
        else:
            shutil.rmtree(mydir)
            raise Exception("no metadata found")

    # clean up our own tempspace
    shutil.rmtree(mydir)
    return 0

 
def main():
    return -1
    
if __name__ == "__main__":
    sys.exit(main())

