/*
 * Decompiled with CFR 0.152.
 */
package com.tobisas.dir2cbz;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;

public class Program {
    private static FileFilter DIR_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory();
        }
    };

    public static void main(String[] args) {
        String startPath = args.length > 0 ? args[0] : ".";
        File baseDir = new File(startPath);
        if (!baseDir.isDirectory()) {
            Program.log(String.format("Given path '%s' is not a directory!", startPath));
            return;
        }
        Program.log("StartPath = " + baseDir.getAbsolutePath());
        Program.zipDemDirs(baseDir);
    }

    private static void zipDemDirs(File baseDir) {
        File[] fileArray = baseDir.listFiles(DIR_FILTER);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File dir = fileArray[n2];
            Program.zipDir(dir);
            ++n2;
        }
    }

    private static void zipDir(File dir) {
        block6: {
            String cbzFilePath = String.format("%s.cbz", dir.getAbsolutePath().trim());
            ZipOutputStream cbzOutStream = null;
            try {
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(cbzFilePath);
                    cbzOutStream = new ZipOutputStream(fileOutputStream);
                    for (File file : Program.getAllFiles(dir)) {
                        String zipName = file.getAbsolutePath().substring(dir.getAbsolutePath().length() + 1);
                        ZipEntry zipEntry = new ZipEntry(zipName);
                        cbzOutStream.putNextEntry(zipEntry);
                        FileInputStream fileIn = new FileInputStream(file);
                        IOUtils.copyLarge(fileIn, cbzOutStream);
                        cbzOutStream.closeEntry();
                        IOUtils.closeQuietly(fileIn);
                    }
                    cbzOutStream.finish();
                    Program.log("Created CBZ: " + cbzFilePath);
                }
                catch (IOException ex) {
                    Program.log("Unexpected error while creating zip: " + ex.getMessage());
                    IOUtils.closeQuietly(cbzOutStream);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(cbzOutStream);
                throw throwable;
            }
            IOUtils.closeQuietly(cbzOutStream);
        }
    }

    private static List<File> getAllFiles(File dir) {
        ArrayList<File> result = new ArrayList<File>();
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            if (child.isFile()) {
                result.add(child);
            } else if (child.isDirectory()) {
                result.addAll(Program.getAllFiles(child));
            }
            ++n2;
        }
        return result;
    }

    private static void log(String string) {
        System.out.println(string);
    }
}

