#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
from __future__ import (unicode_literals, division, absolute_import,
                        print_function)

__license__   = 'GPL v3'
__copyright__ = '2011, Pr.BarnArt, based on the Barnes work by Grant Drake and BOL_NL'
__docformat__ = 'restructuredtext en'

try:
    from PyQt5 import Qt as QtGui
except ImportError:
    from PyQt4 import QtGui
try:
    from PyQt5.Qt import QLabel, QGridLayout, Qt, QGroupBox, QCheckBox
except ImportError:
    from PyQt4.Qt import QLabel, QGridLayout, Qt, QGroupBox, QCheckBox	


from calibre.gui2.metadata.config import ConfigWidget as DefaultConfigWidget
from calibre.utils.config import JSONConfig

STORE_NAME = 'Options'
KEY_MAX_DOWNLOADS = 'maxDownloads'
KEY_COMMENTS_INMONDADORI_IT= 'get comments inmondadori_it'
KEY_COVER_INMONDADORI_IT='get cover from inmondadori_it'
KEY_CHINESE='no get_udc'


DEFAULT_STORE_VALUES = {
    KEY_MAX_DOWNLOADS: 1,
	KEY_COMMENTS_INMONDADORI_IT: False,
	KEY_COVER_INMONDADORI_IT: False,
	KEY_CHINESE: False
}

# This is where all preferences for this plugin will be stored
plugin_prefs = JSONConfig('plugins/ANOBII')

# Set defaults
plugin_prefs.defaults[STORE_NAME] = DEFAULT_STORE_VALUES


class ConfigWidget(DefaultConfigWidget):

    def __init__(self, plugin):
        DefaultConfigWidget.__init__(self, plugin)
        c = plugin_prefs[STORE_NAME]

        other_group_box = QGroupBox('Other options', self)
        self.l.addWidget(other_group_box, self.l.rowCount(), 0, 1, 2)
        other_group_box_layout = QGridLayout()
        other_group_box.setLayout(other_group_box_layout)

        max_label = QLabel('Maximum title/author search matches to evaluate (1 = fastest):', self)
        max_label.setToolTip('inmondadori.it do not always have links to large covers for every ISBN\EAN\n'
                             'of the same book. Increasing this value will take effect when doing\n'
                             'title/author searches to consider more ISBN editions.\n\n'
                             'This will increase the potential likelihood of getting a larger cover\n'
                             'though does not guarantee it.')
        other_group_box_layout.addWidget(max_label, 0, 0, 1, 1)
        self.max_downloads_spin = QtGui.QSpinBox(self)
        self.max_downloads_spin.setMinimum(1)
        self.max_downloads_spin.setMaximum(5)
        self.max_downloads_spin.setProperty('value', c.get(KEY_MAX_DOWNLOADS, DEFAULT_STORE_VALUES[KEY_MAX_DOWNLOADS]))
        other_group_box_layout.addWidget(self.max_downloads_spin, 0, 1, 1, 1)
        other_group_box_layout.setColumnStretch(2, 1)
		
	
		self.comments_inmondadori_it_checkbox = QCheckBox('Get description from inmondadori.it if available', self)
        self.comments_inmondadori_it_checkbox.setToolTip('The book description is taken from ANOBII by default. If you think inmondadori.it is more complete, you can use this option')
        self.comments_inmondadori_it_checkbox.setChecked(c.get(KEY_COMMENTS_INMONDADORI_IT, DEFAULT_STORE_VALUES[KEY_COMMENTS_INMONDADORI_IT]))
        other_group_box_layout.addWidget(self.comments_inmondadori_it_checkbox, 1, 0, 1, 3)
		
		self.cover_inmondadori_it_checkbox = QCheckBox('Get cover from inmondadori.it if available', self)
        self.cover_inmondadori_it_checkbox.setToolTip('The cover is taken from ANOBII by default. If you think inmondadori.it is better, you can use this option')
        self.cover_inmondadori_it_checkbox.setChecked(c.get(KEY_COVER_INMONDADORI_IT, DEFAULT_STORE_VALUES[KEY_COVER_INMONDADORI_IT]))
        other_group_box_layout.addWidget(self.cover_inmondadori_it_checkbox, 2, 0, 1, 3)
		
		self.chinese_checkbox = QCheckBox('Use for CJK characters', self)
        self.chinese_checkbox.setToolTip('Set to get p.e. chinese characters as output')
        self.chinese_checkbox.setChecked(c.get(KEY_CHINESE, DEFAULT_STORE_VALUES[KEY_CHINESE]))
        other_group_box_layout.addWidget(self.chinese_checkbox, 3, 0, 1, 3)

		other_group_box2 = QGroupBox('Errors and Requests', self)
        self.l.addWidget(other_group_box2, self.l.rowCount(), 0, 1, 2)
        other_group_box2_layout = QGridLayout()
        other_group_box2.setLayout(other_group_box2_layout)
		txt1_label=QLabel('At the forum of Mobileread.com, section Calibre->Plugins, there is a special thread for ANOBII!')
		txt_label=QLabel('<a href="http://www.mobileread.com/forums/showthread.php?t=142708">Please report errors or requests over here - CLICK </a>', self)
		txt_label.setOpenExternalLinks(True)
		other_group_box2_layout.addWidget(txt1_label)
		other_group_box2_layout.addWidget(txt_label)		
		
      
    def commit(self):
        DefaultConfigWidget.commit(self)
        new_prefs = {}
        new_prefs[KEY_MAX_DOWNLOADS] = int(unicode(self.max_downloads_spin.value()))
        new_prefs[KEY_COVER_INMONDADORI_IT] = self.cover_inmondadori_it_checkbox.checkState() == Qt.Checked
        new_prefs[KEY_COMMENTS_INMONDADORI_IT] = self.comments_inmondadori_it_checkbox.checkState() == Qt.Checked
		new_prefs[KEY_CHINESE] = self.chinese_checkbox.checkState() == Qt.Checked
        plugin_prefs[STORE_NAME] = new_prefs

