#!/bin/sh
#enableNightmodeOn300plus=false
enableNightmodeOn300plus=true
kbmenudir=/mnt/onboard/.kobo/kbmenu
sh $kbmenudir/onstart/feedfmon.sh
( usleep 400000; /etc/init.d/on-animator.sh ) &

(
/usr/local/Kobo/pickel disable.rtc.alarm

if [ ! -e /etc/wpa_supplicant/wpa_supplicant.conf ]; then
    cp /etc/wpa_supplicant/wpa_supplicant.conf.template /etc/wpa_supplicant/wpa_supplicant.conf
fi

echo 1 > /sys/devices/platform/mxc_dvfs_core.0/enable

/sbin/hwclock -s -u
) &

currentRotation=$(cat /sys/class/graphics/fb0/rotate)

export NICKEL_HOME=/mnt/onboard/.kobo
export LD_LIBRARY_PATH=/usr/local/Kobo


if [ ! -e /usr/local/Kobo/platforms/libkobo.so ]; then
    export QWS_KEYBOARD=imx508kbd:/dev/input/event0
    export QT_PLUGIN_PATH=/usr/local/Kobo/plugins
    if [ -e /usr/local/Kobo/plugins/gfxdrivers/libimxepd.so ]; then
        export QWS_DISPLAY=imxepd
    else
        export QWS_DISPLAY=Transformed:imx508:Rot90
        export QWS_MOUSE_PROTO="tslib_nocal:/dev/input/event1"
    fi
    /usr/local/Kobo/hindenburg &
# [ $PLATFORM != freescale ] && rm -rf /dev/mmcblk1* && udevadm trigger &
    if [ -e /root/screenInv.so ]; then
        LD_PRELOAD="/opt/cfw/preload/hook.so /root/screenInv.so" /usr/local/Kobo/nickel -qws -skipFontLoad
    else
        LD_PRELOAD="/opt/cfw/preload/hook.so" /usr/local/Kobo/nickel -qws -skipFontLoad
    fi
else
    /usr/local/Kobo/hindenburg &
    insmod /drivers/$PLATFORM/misc/lowmem.ko &
    [ `cat /mnt/onboard/.kobo/Kobo/Kobo\ eReader.conf | grep -c dhcpcd=true` == 1 ] && dhcpcd -d -t 10 &
    if [ -e /root/screenInv.so ] && [ "$enableNightmodeOn300plus" == "true" ]; then
        LD_PRELOAD="/opt/cfw/preload/hook.so /root/screenInv.so" /usr/local/Kobo/nickel -platform kobo -skipFontLoad
    else
        LD_PRELOAD="/opt/cfw/preload/hook.so" /usr/local/Kobo/nickel -platform kobo -skipFontLoad
    fi
fi

if [ "$currentRotation" != "$(cat /sys/class/graphics/fb0/rotate)" ]; then
    echo "$currentRotation" > /sys/class/graphics/fb0/rotate
fi

if [ "$PRODUCT" == "dragon" ]; then
    reboot
fi
