﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net.Http;
using System.Threading.Tasks;
using System.IO;
using System.Text.RegularExpressions;

namespace AmazonRatings
{

    class Program
    {

        /*
         * Das funktioniert nicht:
         * "340","google:WYmFHAAACAAJ,isbn:9783552043312,amazon_de:3552043314" liefert:
         * calibredb set_metadata 340 -f #amazonrating: -f #amazonnumratings:9
         * 
         * Obwohl keine Bewertungen vorhanden sind -> noch checken!
         * 
         */

        public static string path = "C:\\Users\\klaus\\Documents\\Technik\\EBook\\";
        public static string nameIDList = "AmazonIDs.csv";
        public static string nameRatings = "SetAmazonRatings2.bat";
        public static string amazonURL = "http://www.amazon.de/dp/";

        public static string ratingBefore = "\"";
        public static string ratingAfter = " von 5 Sternen";
        public static string numRatingBefore = ">";
        public static string numRatingAfter = " Kundenrezension";
        public static string amazonIDBefore = "amazon_de:";
        public static string amazonIDAfter = ",";

        public static string calibreCmd = "calibredb set_metadata ";
        public static string calibreFieldRating = "#amazonrating";
        public static string calibreFieldNumRatings = "#amazonnumratings";

            
        static void Main()
        {

            // Read input csv with IDs
            string[] IDList = File.ReadAllLines(path + nameIDList);
            List<Crating> ratingList = new List<Crating>();

            /* Input file looks like this:
                id,identifiers
                "373","isbn:9783548034522,amazon_de:3548034527,google:IC8eSQAACAAJ"
                "385","google:RnrIMgEACAAJ,isbn:9783841901705,amazon_de:3841901700"
                "388","amazon_de:3257201818,isbn:9783257201819"
                "541","google:LrsF5EE52OwC,amazon_de:3404921143,isbn:9783404921140
            */

            string numRatings = "";
            string rating;
            string httpResult;
            string calibreID;
            string amazonID;
            List<string> CommandLines = new List<string>();

            Crating Irating;
            int numIDs = IDList.Length;
            int i = 1;


            foreach (string ID in IDList)
            {
                calibreID = findCalibreID(ID);
                Console.Write("working on ID: " + calibreID + ": " + i + "/" + numIDs); i++;
                amazonID = findPartInStringStartBefore(ID, amazonIDBefore, amazonIDAfter);

                // fetch rating and numRatings from webpage
                if (amazonID != "")
                {
                    httpResult = downladPage(amazonURL + amazonID);
                    string httpLine = findRatingLine(httpResult, amazonID);
                    rating = findPartInStringStartAfter(httpLine, ratingBefore, ratingAfter, 5);
                    if (rating != "") 
                      numRatings = findPartInStringStartAfter(httpResult, numRatingBefore, numRatingAfter, 10);
                    if (rating != "" || numRatings != "")
                    {
                        Irating = new Crating(calibreID, rating, numRatings);
                        ratingList.Add(Irating);
                        Console.WriteLine(": Ratings found!");
                    }
                    else Console.WriteLine(": No Ratings found!");
                }
                else Console.WriteLine(": No Amazon-ID found!");

            }

            foreach (Crating localRating in ratingList)
            {
                CommandLines.Add(localRating.command());
            }
            CommandLines.Add("pause");

            File.WriteAllLines(path + nameRatings, CommandLines);

            Console.WriteLine("Finished - Press Enter to end program");
            Console.ReadLine();

        }


        static string downladPage(string website)
        {
            string responseString = "";
            using (var client = new HttpClient())
            {
                var response = client.GetAsync(website).Result;

                if (response.IsSuccessStatusCode)
                {
                    // by calling .Result you are performing a synchronous call
                    var responseContent = response.Content;

                    // by calling .Result you are synchronously reading the result
                    responseString = responseContent.ReadAsStringAsync().Result;

                }
            }
            return responseString;
        }


        static string findPartInStringStartAfter(string input, string before, string after, int maxDiff)
            // returns the part of input between the string <before> and <after>, with a max difference of maxDiff
        {
            string sResult = "";
            int iStart;
            int iStop = input.IndexOf(after);
            if (iStop > 0)
            {
                iStart = input.IndexOf(before, iStop - maxDiff) + before.Length;
                if ((iStart > 0) && (iStop > iStart)) sResult = input.Substring(iStart, iStop - iStart);
            }
            return sResult;
        }

        static string findPartInStringStartBefore(string input, string before, string after)
        // returns the part of input between the string <before> and <after>, with a max difference of maxDiff
        {
            string sResult="";
            int iStart = input.IndexOf(before) + before.Length;
            if (iStart > 0 + before.Length)
            {
                int iStop = input.IndexOf(after, iStart);
                if (iStop > 0) sResult = input.Substring(iStart, iStop - iStart); 
                else sResult = input.Substring(iStart, input.Length - iStart - 1);
            }
            return sResult;
        }

        static string findCalibreID(string input)
        // returns the first string und "", ended with ","
        {
            string sResult = "";
            int iStart = 1;
            int iStop = input.IndexOf(",") - 2;
            if (iStop > 0) sResult = input.Substring(iStart, iStop);
            if (sResult == "id") sResult = "";
            return sResult;
        }

        static string findRatingLine(string input, string amazonID)
        // returns the first string und "", ended with ","
        {
            string sResult = "";
            //input = "product-reviews/3548034527ksjdhf jksd hfskjvon 5 Sternenjdsk fjkdsf hdsjk";
            // stars.*3548034527.*von 5 Sternen

            string pattern = @"product-reviews/" + amazonID + ".*von 5 Sternen";
//            string pattern = @"rating-stars.*" + amazonID + ".*von 5 Sternen";

            // Instantiate the regular expression object.
            Regex r = new Regex(pattern);

            // Match the regular expression pattern against a text string.
            Match m = r.Match(input);

            return m.Value;

        }

        //<span class="rating-stars"><span class="crAvgStars" style="white-space:no-wrap;"><span class="asinReviewsSummary" name="3257205368"><a href="http://www.amazon.de/product-reviews/3257205368/ref=pd_sim_b_cm_cr_acr_img_4?ie=UTF8&refRID=0F3KW2A5QYEY3WT4B8ZW"><span class="swSprite s_star_4_0 " title="4.2 von 5 Sternen" ><span>4.2 von 5 Sternen</span></span></a>&nbsp;</span>(<a href="http://www.amazon.de/product-reviews/3257205368/ref=pd_sim_b_cm_cr_acr_txt_4?ie=UTF8&refRID=0F3KW2A5QYEY3WT4B8ZW">10</a>)</span></span>



    }
}
