# !/bin/bash -e

# Needs an x-compile env setup (don't forget to export KINDLE_TC first)...
echo "* Launching ${KINDLE_TC} build . . ."

# link against OpenSSL statically on the K5
if [[ "${KINDLE_TC}" == "K5" || "${KINDLE_TC}" == "PW2" ]] ; then
	echo "* OpenSSL trickery to link statically . . ."
	for my_lib in libcrypto.so libcrypto.so.1.0.0 libssl.so libssl.so.1.0.0 ; do
		mv -v ${TC_BUILD_DIR}/lib/{${my_lib},_${my_lib}}
	done
fi

mkdir -p ${KINDLE_TC}
echo "${CROSS_TC}-gcc accidental_irc.c ${CPPFLAGS} -D_OPENSSL -Wall ${CFLAGS} ${LDFLAGS} -o ${KINDLE_TC}/accirc -lncurses -lssl -lcrypto -ldl -lz"
${CROSS_TC}-gcc accidental_irc.c ${CPPFLAGS} -D_OPENSSL -Wall ${CFLAGS} ${LDFLAGS} -o ${KINDLE_TC}/accirc -lncurses -lssl -lcrypto -ldl -lz
echo "${CROSS_TC}-strip --strip-unneeded ${KINDLE_TC}/accirc"
${CROSS_TC}-strip --strip-unneeded ${KINDLE_TC}/accirc

if [[ "${KINDLE_TC}" == "K5" || "${KINDLE_TC}" == "PW2" ]] ; then
	echo "* Undo OpenSSL trickery :)"
	for my_lib in libcrypto.so libcrypto.so.1.0.0 libssl.so libssl.so.1.0.0 ; do
		mv -v ${TC_BUILD_DIR}/lib/{_${my_lib},${my_lib}}
	done
fi
