from __future__ import print_function
import sys, os
from lxml import etree


def main(argv=sys.argv):
    #full path to toc.ncx
    toc=argv[1]
     
    #from toc paths to content.opf and (future) nav.html
    nav=os.path.dirname(toc)+"/Text/nav.xhtml"
    opf=os.path.dirname(toc)+"/content.opf"
    #landmarkstag
    #landmarks_tag='<nav epub:type="landmarks" id="guide" xmlns:epub="http://www.idpf.org/2007/ops">'
    landmarks_title='<h2>Guide</h2>'
    #manifest entry for nav.xhtml
    nav_manifestItem='<item href="Text/nav.xhtml" \
        id="nav" media-type="application/xhtml+xml" properties="nav"/>'
    #spine item for nav.xhtml
    nav_spineItem='<itemref idref="nav" linear="no" />'
    
    #set explicit parser
    parser=etree.XMLParser(encoding='utf-8', ns_clean=True)
    
    #parse toc.ncx
    dom = etree.parse(toc)
    #parse ncx2end-0.1.xsl
    xslt = etree.parse("ncx2end-0.1.xsl")
    
    #transform toc.ncx according to xsl
    transform = etree.XSLT(xslt)
    newdom = transform(dom)
    html_root=newdom.getroot()

    ns1=html_root.nsmap
    
    #print(ns1)
    body_tag=".//{%s}body" % ns1[None]
    body=html_root.find(body_tag)
    
    #parse content.opf
    opftree=etree.parse(opf,parser)
    #get root element
    root=opftree.getroot()
    #tags
    ns=root.nsmap
    #need namespaces here
    m_tag="{%s}manifest" % ns[None]
    #spine tag
    s_tag="{%s}spine" % ns[None]
    #guide tag
    g_tag="{%s}guide" % ns[None]   
    #itemref tag
    #i_tag=".//{%s}itemref" % ns[None]
    
    #find manifest and spie tags
    manifest=root.find(m_tag)
    spine=root.find(s_tag)
    guide=root.find(g_tag)
 
    #shell we add landmarks?
    if len(guide)>0:
        epub_type="{%s}type" % ns1['epub']
        ats={epub_type: "landmarks", "id": "guide"}       
        landmarks=etree.SubElement(body,"nav", attrib=ats)
        landmarks.append(etree.XML(landmarks_title))
        for child in guide:
            m_href=child.get('href')
            m_title=child.get('title')
            m_type=child.get('type')
            li=etree.SubElement(landmarks,"li")
            aeattr={epub_type:m_type,'href':m_href}
            ae=etree.SubElement(li,"a",attrib=aeattr)
            ae.text=m_title
            
    #open nav.xhtml for writing
    fnav=file(nav,"w")
    #write transformation to nav.xhtml
    print(etree.tostring(newdom, pretty_print=True),file=fnav)
    fnav.close()
     

    manifest.append(etree.XML(nav_manifestItem))
    spine.append(etree.XML(nav_spineItem))

    
    fopf=file(opf,'w')
    print(etree.tostring(opftree, pretty_print=True),file=fopf)
    fopf.close()
    
    
if __name__ == "__main__":
    sys.exit(main())    