#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai

import sys, os

XML = """<?xml version="1.0" encoding="UTF-8"?>
<display_options>
    <platform name="*">
        <option name="specified-fonts">true</option>
    </platform>
</display_options>"""
   
def main(argv=sys.argv):
    if len(argv) < 2:
        print "Usage:"
        print "  aplle_xml.py infile"
        return 1
    else:
        infile=argv[1]        
        apple_xml_path = os.path.join(infile, 'META-INF', 'com.apple.ibooks.display-options.xml')
        print apple_xml_path
        with open(apple_xml_path, 'wb') as f:
            f.write(XML.encode('utf-8'))
            os.utime(infile, None)

if __name__ == "__main__":
    sys.exit(main())
