import sys
import os
from os.path import expanduser
import subprocess
from Tkinter import Tk
from tkFileDialog import askopenfilename
from sys import stderr

#sys.path.append(os.path.join(sys.path[0],"DeDRM_Windows_Application/DeDRM_App/DeDRM_lib/lib/"))

def main(argv=sys.argv):
    
    #temporary folder from Sigil
    deDRMdir=argv[1] 
    if not os.path.exists(deDRMdir):
        os.makedirs(deDRMdir)

#check preferances dir: if exists and is not empty
#get book to be processed and pass it to DeDRM_App,
#if not run DeDRM_App without parameters
#set deDRM folder first

    prefdir ='DeDRMPrefs'

    #taken from simpleprefs
    if sys.platform.startswith('win'):
        import _winreg as winreg
        regkey = winreg.OpenKey(winreg.HKEY_CURRENT_USER, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders\\")
        path = winreg.QueryValueEx(regkey, 'Local AppData')[0]
        prefdir = path + os.sep + prefdir
    elif sys.platform.startswith('darwin'):
        home = os.getenv('HOME')
        prefdir = os.path.join(home,'Library','Preferences','org.' + prefdir)
    else:
    # linux and various flavors of unix
        home = os.getenv('HOME')
        prefdir = os.path.join(home,'.' + prefdir)
 
    if not os.path.exists(prefdir):
        os.makedirs(prefdir)

    entry="./DeDRM_Windows_Application/DeDRM_App/DeDRM_lib/DeDRM_App.pyw" 
    outdirpref=prefdir+'/outdir.txt'
    store=prefdir+'/old_outdir.txt'
    cmd=[entry]
    FNULL = open(os.devnull, 'w')  
    if os.path.exists(prefdir):
        if os.path.exists(outdirpref):
            os.rename(outdirpref,store)
        f=open(outdirpref,"w")
        f.write(deDRMdir)
        f.close()
        Tk().withdraw() #keep the root window from appearing
        #home=expanduser("~")
        filename = askopenfilename(initialdir=home ,title="Chose book to process:") # show an "Open" dialog box and return the path to the selected file
        if filename:
            book=[filename]
            cmd.extend(book)
    
    #os.chdir('./DeDRM_Windows_Application/DeDRM_App/DeDRM_lib/')
    #subprocess.call(cmd, stdout=FNULL, stderr=subprocess.STDOUT)
    subprocess.call(cmd, stdout=FNULL)
    if os.path.exists(store):
        os.remove(outdirpref)
        os.rename(store, outdirpref)

if __name__ == "__main__":
    sys.exit(main())
