#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#include <linux/fb.h>
#include <sys/mman.h>
#include <sys/ioctl.h>
#include "mxcfb.h" // see ref  mx50_evk_rd3_linux.pdf from freescale in L2.6.35_11.04.01_ER_docs.tar.gz

typedef struct  {
	int fbfd;
	struct fb_var_screeninfo vinfo;
	struct fb_fix_screeninfo finfo;
	// mapped frame buffer address
	unsigned short int *fb; // 16 bit ie two pixels should prob change
	size_t fb_size; 
} fbdev;


int main()
{
	
	int	rc;
	fbdev *fb;
	fb = malloc(sizeof(*fb));

	// Open the file for reading and writing
	if ((fb->fbfd = open("/dev/graphics/fb0", O_RDWR)) == -1) {
		printf("Error opening fb device");	
	}
	
	// Get fixed screen information
	rc=ioctl(fb->fbfd, FBIOGET_FSCREENINFO, &fb->finfo);
	if (rc != 0)
	{
		printf("Ioctl 1 error: %d\n", errno);
		return 0;
	}

	rc=ioctl(fb->fbfd, FBIOGET_VSCREENINFO, &fb->vinfo);
	if (rc != 0)
	{
		printf("Ioctl 2 error: %d\n", errno);
		return 0;
	}


	// Configure Screen
	fb->vinfo.bits_per_pixel = 8;
	fb->vinfo.grayscale = 3; // 0 is landscape right handed, 3 is portrait
	fb->vinfo.rotate = 0;
    	printf("beforeioctl\n");
	if (ioctl(fb->fbfd, FBIOPUT_VSCREENINFO, &fb->vinfo) == -1) {
		printf("Error configuring display (Ioctl 3): %d\n", errno);
	}

	// Figure out the size of the screen in bytes
	fb->fb_size = fb->vinfo.xres_virtual * fb->vinfo.yres_virtual * fb->vinfo.bits_per_pixel / 8;
	printf("screen size = 0x%x\n", fb->fb_size);

	// Map the device to memory
	fb->fb = mmap(0, fb->fb_size, PROT_READ | PROT_WRITE, MAP_SHARED,fb->fbfd, 0);
	if (fb->fb == MAP_FAILED)
	{
		printf("mmap failed: %d\n", errno);
		return 0;
	}

	// Setup Update region struct
	struct mxcfb_update_data region; //see mxfb.h
	int marker = 1;
	region.update_marker = marker; /* Marker used when waiting for completion */
	region.update_region.top = 0;
	region.update_region.left = 0;
	region.update_region.width = 758;
	region.update_region.height = 1024;
	region.waveform_mode = WAVEFORM_MODE_AUTO;/* Waveform mode for update */
	region.update_mode = UPDATE_MODE_FULL ; /* Update mode selection (partial/full) */
	region.temp = TEMP_USE_AMBIENT;
	region.flags = EPDC_FLAG_FORCE_MONOCHROME ; /* Select options for the current update */


	unsigned short int color;
	// clear screen
	color = 0xFFFF; // white two pixels
    	size_t size = (fb->fb_size)/2;
     	int i,j;
    	for ( i=1 ; i < size ; i++) 
	{
        	fb->fb[i] = color ;
    	}
 	// put rectangle in corner
	color = 0 ; // black
    	for ( i=1 ; i < 50 ; i++) 
	{
        	for (j=0 ; j < 200 ; j++)
        		fb->fb[ i+400*j] = color;
    	}
	rc = ioctl(fb->fbfd , MXCFB_SEND_UPDATE, &region);
	if (rc != 0)
	{
		printf("Ioctl 4 error: %d\n", errno);
		//return 0;
	}
	sleep(1); // only here to make easier to see change

	/* region.update_mode =  UPDATE_MODE_PARTIAL  this is supposed to do a full refresh see second post
	 http://www.blogger.com/comment.g?blogID=9054609445298212106&postID=7075212809223613654 http://code.google.com/p/mediaz/ */
	region.flags = EPDC_FLAG_ENABLE_INVERSION ;
	sleep(1); // only here to make easier to see change
  	rc = ioctl(fb->fbfd , MXCFB_SEND_UPDATE, &region);
	if (rc != 0)
	{
		printf("Ioctl 5 error: %d\n", errno);
		//return 0;
	}
	rc = ioctl(fb->fbfd, MXCFB_WAIT_FOR_UPDATE_COMPLETE, &marker);
	if (rc != 0)
	{
		printf("Ioctl 6 error: %d\n", errno);
		//return 0;
	}
	sleep(1); // only here to make easier to see change
	// blank screen again
	color = 0xFFFF;
	region.flags = EPDC_FLAG_FORCE_MONOCHROME ;

	for ( i=1 ; i < size ; i++) 
	{
        	fb->fb[i] = color ;
    	} 
	rc = ioctl(fb->fbfd , MXCFB_SEND_UPDATE, &region);
	if (rc != 0)
	{
		printf("Ioctl 7 error: %d\n", errno);
		//return 0;
	}

	return 0;
}
