#!/bin/sh

kbmenudir=/mnt/onboard/.kobo/kbmenu
frontlightprg=$kbmenudir/tools/frontlight
installUpdate="TRUE"
preserveRcS="FALSE"


# switch off leds begin
echo "ch 4" > /sys/devices/platform/pmic_light.1/lit
echo "cur 0" > /sys/devices/platform/pmic_light.1/lit
echo "dc 0" > /sys/devices/platform/pmic_light.1/lit
#switch off leds end

case $PRODUCT in
  kraken|phoenix)
    ksmImageWidthPortrait=568
    ksmImageWidthLandscape=750
    ;;
  dragon)
    ksmImageWidthPortrait=566
    ksmImageWidthLandscape=750
    ;;
  *)
    ksmImageWidthPortrait=566
    ksmImageWidthLandscape=750
    ;;
esac


kobomenuFontsize=40
kobomenuMenuBarFontsize=25

frontlightOnLevel=4
insertCRportrait=true
insertCRlandscape=true
combineCoolreaderAdditions=true
insertNickelKoreaderSwitch=true
insertKoreaderNickelSwitch=true
combineKoreaderAdditions=true
enablerotation=false
preventfreeze=false

if [ -e $kbmenudir/usersettings.txt ]; then
  checkscript=$(sh -n $kbmenudir/usersettings.txt 2>&1)
  if [ "$checkscript" == "" ]; then
    . $kbmenudir/usersettings.txt
  fi
fi
export kobomenuFontsize
export kobomenuMenuBarFontsize
export ksmImageWidthPortrait
export ksmImageWidthLandscape



if [ "$PRODUCT" == "dragon" ]; then
  sh $kbmenudir/kobomenu.sh -autoselectafter=0
fi

if [ "$preventfreeze" == "true" ]; then
  sh $kbmenudir/onstart/preventfreeze.sh &
fi



setoptions() {
  moptions="info:help"
  if [ "$enablerotation" == "true" ]; then
    moptions="$moptions toggle_rotation:toggle.png"
  fi
  if [ $PRODUCT != trilogy ] && [ $PRODUCT != pixie ]; then
    moptions="$moptions front_light_on:execute.png front_light_off:execute.png"
  fi
  mupdateoptions=""
  if [ -e /mnt/onboard/.kobo/Kobo.tgz ] || [ -e /mnt/onboard/.kobo/KoboRoot.tgz ]; then
    installUpdate="FALSE"
    moptions="$moptions handle_update:gear.png "
    if [ -e /mnt/onboard/.kobo/KoboRoot.tgz ]; then
      mupdateoptions="$mupdateoptions install_partial_update:execute.png"
    fi
    mupdateoptions="$mupdateoptions install_update:execute.png"
    mupdateoptions="$mupdateoptions delete_update:execute.png"
    mupdateoptions="$mupdateoptions return"
  fi

  moptions="$moptions start_nickel:book.png"

  if [ -e /mnt/onboard/.kobo/koreader/reader.lua ]; then
    moptions="$moptions start_koreader:book.png"
    if  [ "$combineKoreaderAdditions" == "true" ]; then
      KoreaderAdditionsmoptions=
      [ "$insertNickelKoreaderSwitch" == "true" ] && KoreaderAdditionsmoptions="$mKoreaderAdditionsmoptions start_nickel_koreader_switch:book.png"
      [ "$insertKoreaderNickelSwitch" == "true" ] && KoreaderAdditionsmoptions="$KoreaderAdditionsmoptions start_koreader_nickel_switch:book.png"
      [ -d "$kbmenudir/koreaderfindsh" ] && KoreaderAdditionsmoptions="$KoreaderAdditionsmoptions find_and_open:menu.png"
      KoreaderAdditionsmoptions="$KoreaderAdditionsmoptions return:arrowup.png"
      moptions="$moptions koreader_additions:menu.png"
    else
      [ "$insertNickelKoreaderSwitch" == "true" ] && moptions="$moptions start_nickel_koreader_switch:book.png"
      [ "$insertKoreaderNickelSwitch" == "true" ] && moptions="$moptions start_koreader_nickel_switch:book.png"
      [ -d "$kbmenudir/koreaderfindsh" ] && KoreaderAdditionsmoptions="$KoreaderAdditionsmoptions find_and_open:menu.png"
    fi
  fi
  if [ -e /mnt/onboard/.kobo/KoboLauncher/launcher ]; then
    moptions="$moptions start_kobolauncher:rocket.png"
  fi

  if [ -e /mnt/onboard/.kobo/vlasovsoft/launcher ]; then
    moptions="$moptions start_vlasovsoftlauncher:rocket.png"
    usbnetavailable="true"
    if  [ "$combineCoolreaderAdditions" == "true" ]; then
      CoolreaderAdditionsmoptions=
      [ "$insertCRportrait" == "true" ] && CoolreaderAdditionsmoptions="$CoolreaderAdditionsmoptions start_coolreader:book.png"
      [ "$insertCRlandscape" == "true" ] && CoolreaderAdditionsmoptions="$CoolreaderAdditionsmoptions start_coolreader_ls:book.png"
      CoolreaderAdditionsmoptions="$CoolreaderAdditionsmoptions return:arrowup.png"
      moptions="$moptions coolreader:menu.png"
    else
      [ "$insertCRportrait" == "true" ] && moptions="$moptions start_coolreader:book.png"
      [ "$insertCRlandscape" == "true" ] && moptions="$moptions start_coolreader_ls:book.png"
    fi
  else
    usbnetavailable="false"
  fi
  export usbnetavailable

  moptions="$moptions usb:usb.png scripts:menu.png sleep:moon reboot:restart.png power_off:poweroff.png"
}

mrotation="90"
export mrotation
udevadm trigger
#---- do the menu loop
selection=""
while [ "$selection" != "EXIT" ]; do
  setoptions
  selection=$(sh $kbmenudir/kobomenu.sh $moptions)
  case $selection in
    info )
      sh $kbmenudir/kbmessage.sh "-f $kbmenudir/txt/start_info.html"
      ;;
    handle_update )
      binfo="capacity: `cat /sys/devices/platform/pmic_battery.1/power_supply/mc13892_bat/capacity`"
      binfo=${binfo// /_}
      updateselection=$(sh $kbmenudir/kobomenu.sh -infolines=1 "-infotext=$binfo" $mupdateoptions)
      case $updateselection in
        install_update )
          installUpdate="TRUE"
          preserveRcS="FALSE"
          selection="EXIT"
          ;;
        install_partial_update )
          installUpdate="TRUE"
          preserveRcS="TRUE"
          selection="EXIT"
          ;;
        delete_update )
          rm -f /mnt/onboard/.kobo/KoboRoot.tgz
          rm -f /mnt/onboard/.kobo/Kobo.tgz
          rm -rf /mnt/onboard/.kobo/upgrade
          rm -f /mnt/onboard/manifest.md5sum
          ;;
        return )
          updateselection=""
          ;;
      esac
      ;;
    toggle_rotation )
      if [ "$mrotation" == "0" ]; then
        mrotation="90"
      elif [ "$mrotation" == "90" ]; then
        mrotation="180"
      elif [ "$mrotation" == "180" ]; then
        mrotation="270"
      elif [ "$mrotation" == "270" ]; then
        mrotation="0"
      fi
      export mrotation
      ;;
    start_nickel )
      sh $kbmenudir/onstart/startreader.sh
      ;;
    power_off )
      sh $kbmenudir/onstart/poweroff.sh
      ;;
    sleep )
      sh $kbmenudir/onstart/suspend.sh
      ;;
    reboot )
      reboot
      ;;
    usb )
      sh $kbmenudir/onstart/scriptmenuusb.sh $kbmenudir/usb
      ;;
    scripts )
      sh $kbmenudir/helpers/list_shscripts.msh $kbmenudir/scripts
      ;;
    start_koreader )
      sh $kbmenudir/onstart/koreader_kobo.sh
      ;;
    start_nickel_koreader_switch )
      sh $kbmenudir/onstart/nickelkoreaderloop.sh
      ;;
    start_koreader_nickel_switch )
      sh $kbmenudir/onstart/koreadernickelloop.sh
      ;;
    koreader_additions )
      koreaderadditionsselection=$(sh $kbmenudir/kobomenu.sh $KoreaderAdditionsmoptions $mupdateoptions)
      case $koreaderadditionsselection in
        start_nickel_koreader_switch )
          sh $kbmenudir/onstart/nickelkoreaderloop.sh
          ;;
        start_koreader_nickel_switch )
          sh $kbmenudir/onstart/koreadernickelloop.sh
          ;;
        find_and_open )
          sh $kbmenudir/helpers/list_shscripts.msh "$kbmenudir/koreaderfindsh"
          ;;
      esac
      ;;
    start_kobolauncher )
      sh $kbmenudir/onstart/start_KoboLauncherA.sh
      ;;
    start_vlasovsoftlauncher )
      sh $kbmenudir/onstart/start_vlasovlauncher.sh
      ;;
    start_coolreader )
      sh $kbmenudir/onstart/cr3.sh
      ;;
    start_coolreader_ls )
      sh $kbmenudir/onstart/cr3_180.sh
      ;;
    coolreader )
      coolreaderselection=$(sh $kbmenudir/kobomenu.sh $CoolreaderAdditionsmoptions $mupdateoptions)
      case $coolreaderselection in
        start_coolreader )
          sh $kbmenudir/onstart/cr3.sh
          ;;
        start_coolreader_ls )
          sh $kbmenudir/onstart/cr3_180.sh
          ;;
      esac
      ;;

    front_light_on )
      $frontlightprg "$frontlightOnLevel"
      ;;
    front_light_off )
      $frontlightprg "0"
      ;;
  esac
done

if [ "$installUpdate" == "TRUE" ]; then

  if [ "$newpickelversion" == "TRUE" ]; then
    /usr/local/Kobo/pickel can-upgrade
    CAN_UPGRADE=$?
  else
    CAN_UPGRADE=1
  fi

  if [ $CAN_UPGRADE == 1 ] && [ -e /mnt/onboard/.kobo/Kobo.tgz ]; then
    zcat /mnt/onboard/.kobo/Kobo.tgz > /dev/null && tar zxf /mnt/onboard/.kobo/Kobo.tgz -C /usr/local/Kobo/ && ( cat /usr/local/Kobo/revinfo >> /usr/local/Kobo/install.log )
    rm /mnt/onboard/.kobo/Kobo.tgz
    echo "Done upgrading..."
  fi
                               
  if [ $CAN_UPGRADE == 1 ] && [ -e /mnt/onboard/.kobo/KoboRoot.tgz ]; then
    zcat /etc/images/$PREFIX\ghostbuster.raw.gz | /usr/local/Kobo/pickel showpic
    /etc/init.d/update-animator.sh &
# Tshering: begin
    if [ "$preserveRcS" == "TRUE"  ]; then
      cp "/etc/init.d/rcS" "$kbmenudir"
      cp "/usr/local/Kobo/udev/usb" "$kbmenudir"
    fi
# Tshering: end

    zcat /mnt/onboard/.kobo/KoboRoot.tgz > /dev/null && tar zxf /mnt/onboard/.kobo/KoboRoot.tgz -C / && ( cat /usr/local/Kobo/revinfo >> /usr/local/Kobo/install.log )



    if [ -e /mnt/onboard/.kobo/upgrade ]; then
      /etc/init.d/upgrade-wifi.sh
      rm -rf /mnt/onboard/.kobo/upgrade
    fi
    rm /mnt/onboard/.kobo/KoboRoot.tgz
    killall update-animator.sh
    echo "Done upgrading..."

    if [ "$preserveRcS" == "TRUE"  ] && [ -e $kbmenudir/rcS ]; then
      cp "$kbmenudir/rcS" "/etc/init.d"
      cp "$kbmenudir/usb" "/usr/local/Kobo/udev"
    fi

    zcat /etc/images/$PREFIX\ghostbuster.raw.gz | /usr/local/Kobo/pickel showpic
    zcat /etc/images/$PREFIX\reboot.raw.gz | /usr/local/Kobo/pickel showpic
    sync
    reboot
  fi

fi

# Emergency exit
reboot

