"""
This script is intended to be run using calibre's Python environment via the "calibre-debug" command.
As such, it will not work in a standalone Python environment as many necessary modules will be unavailable.

This script is run using the following syntax:

  calibre-debug cm2em_calibre.py file.epub

cm2em_calibre.py being the name of this script.
file.epub being the name of the epub file you wish to modify with this script.
"""

from __future__ import print_function
from __future__ import unicode_literals

import sys
from calibre.ebooks.oeb.polish.container import get_container, OEB_STYLES

def convertcm2em(value):
    conv=2.37106301584
    return "%.2f"%(conv*float(value))

def main(argv=sys.argv):
    c = get_container(argv[-1], tweak_mode=True)
    EPUB_DIRTY = False
    for name, mt in c.mime_map.iteritems():
        if mt in OEB_STYLES:
            SHEET_DIRTY = False
            sheet = c.parsed(name)
            for rule in sheet.cssRules:
                if rule.type in (rule.STYLE_RULE, rule.PAGE_RULE):
                    for property in rule.style:
                        val = property.propertyValue
                        for x in val:
                            if x.type == 'DIMENSION' and x.dimension == 'cm':
                                SHEET_DIRTY = True
                                x.cssText = convertcm2em(x.value ) + 'em'

            if SHEET_DIRTY:
                print ('  Modifying: ', name)
                EPUB_DIRTY = True
                c.dirty(name)
            else:
                print ('  No changes to: ', name)

    if EPUB_DIRTY:
        print ('\nChanges saved to: ', argv[-1])
        c.commit()
    else:
        print ('\nNo changes made to: ', argv[-1])

if __name__ == '__main__':
    sys.exit(main())