#!/bin/sh
ROOT=/mnt/onboard/.kobo/vlasovsoft
root=$ROOT/usbnet

#PLATFORM=ntx508
#if [ $DEVICE == TOUCH27 ]; then
#    PLATFORM=freescale
#fi

if [ -f /var/run/dropbear.pid ]
then
    kill `cat /var/run/dropbear.pid`
    ifconfig usb0 down
    rmmod g_ether
    rmmod arcotg_udc
    #msgbox "usbnet" "usb network stopped!"
else

    driver_root=/drivers/$PLATFORM/usb/gadget
    insmod $driver_root/arcotg_udc.ko
    insmod $driver_root/g_ether.ko host_addr=46:0d:9e:67:69:eb dev_addr=46:0d:9e:67:69:ec
    ifconfig usb0 192.168.2.101
    if [ "$?" -ne "0" ] ; then
 #       msgbox "usbnet" "usb network error!"
        exit 1
    fi
    [ ! -e /usr/libexec/sftp-server ] && (mkdir -p /usr/libexec; ln -sf $root/sftp-server /usr/libexec/sftp-server)
    $root/dropbear -E -r $root/host.key.rsa -d $root/host.key.dss > $root/dropbear.log 2>&1
 #   msgbox "usbnet" "usb network started!"
#killall rcS
fi
