#!/bin/sh
export LD_LIBRARY_PATH=./lib

cd ../_hidden

# Kill DBUS and bury remains
killall dbus-daemon
rm /var/run/dbus/*

# Run DBUS
echo Starting DBUS...
cd dbus
./dbus-daemon --config-file=system.conf
cd ..

# Load modules
echo Loading modules...
insmod modules/bluez.o
insmod modules/hci_usb.o
insmod modules/l2cap.o
insmod modules/rfcomm.o

modprobe ppp_generic
modprobe ppp_async

# Run HCID
echo Starting HCID..
killall hcid
cd hcitool
./hcid -f hcid.conf
sleep 2
./passkey-agent --default 1234 &
sleep 1


echo Done. Now plug in your Bluetooth USB dongle and run the second script.
exit