#!/bin/sh
# Change this if the 'pb_sshd' directory has been installed elsewhere.
SSHDIR=/mnt/ext1/applications/pb_sshd

# If you want a pop-up message with the IP address and port for sshd
# displayed at startup, then uncomment the following line, and install
# sh_ivtool.app at that location.
#SH_IVTOOL=/mnt/ext1/system/bin/sh_ivtool.app

# The rest should not require editing.

# Connect to the net first if necessary.
ifconfig eth0 1> /dev/null 2> /dev/null
if [ $? -ne 0 ]; then
  touch /tmp/sshd-connected-to-wifi
  /ebrmain/bin/netagent connect
fi

export PATH="$SSHDIR"/usr/bin:"$SSHDIR"/usr/sbin:$PATH

cd $SSHDIR

./server-keygen.sh

if [ -f create-keys ]; then
	./make-keys.sh
	rm -f create-keys
fi

# To enable debugging output, replace "-q" with "-d" below.
"$SSHDIR"/usr/sbin/sshd \
	-f "$SSHDIR"/etc/ssh/sshd_config \
	-h "$SSHDIR"/etc/ssh/ssh_host_key \
	-h "$SSHDIR"/etc/ssh/ssh_host_dsa_key \
	-h "$SSHDIR"/etc/ssh/ssh_host_ecdsa_key \
	-h "$SSHDIR"/etc/ssh/ssh_host_rsa_key \
	-q -e 1> "$SSHDIR"/sshd.log 2> "$SSHDIR"/sshd.log

if [ -x "$SH_IVTOOL" ]; then
	IP=`ifconfig eth0 | grep "inet addr" | cut -d ':' -f 2 | cut -d ' ' -f 1`
	PORT=`grep Port $SSHDIR/etc/ssh/sshd_config | cut -d ' ' -f 2`
	$SH_IVTOOL -s "sshd is listening at  ${IP}:${PORT}"
fi
