from __future__ import (unicode_literals, division, absolute_import, print_function)
from PyQt4.QtGui import (QDialog, QVBoxLayout)
        
class EditorDlg(QDialog):
    ''' edit html or css unicode text using calibre editor widget'''
    
    def __init__(self, uni, syntax, parent=None):
        QDialog.__init__(self, parent=parent)

        from calibre.gui2.tweak_book.editor.text import TextEdit
        
        editor = TextEdit()
        
        layout = QVBoxLayout()
        layout.addWidget(editor)
        self.setLayout(layout)
        self.setWindowTitle("Manual file edit: %s" % syntax)
        
        print('*** before editor.load_text')
        editor.load_text(uni, syntax)
        print('*** after editor.load_text')

if __name__ == '__main__':
    import sys
    from PyQt4.Qt import QApplication
    
    syntax = 'html'
    #syntax = 'css'
    
    uni = u'<html xmlns="http://www.w3.org/1999/xhtml">\n\n<head>\n  <title>testhtml</title>\n  <meta http-equiv="content-type" content="text/html; charset=utf-8" />\n  <link href="../Styles/stylesheet.css" rel="stylesheet" type="text/css"/>\n</head>\n\n<body class="text">\n\n  <h2 class="hdr">Chapter 1</h2>\n\n  <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>\n\n  <p class="ctr">*\xa0\xa0\xa0\xa0\xa0*\xa0\xa0\xa0\xa0\xa0*</p>\n\n  <p>The above paragraph spacer contains several non-breaking spaces.</p>\n\n</body>\n\n</html>'
    
    if syntax == 'css':
        uni = u'body {\nfont-size: 1em;\nmargin: 0\n}\n'
        
    app = QApplication(sys.argv)
    form = EditorDlg(uni, syntax, parent=None)
    form.show()
    app.exec_()
    