#!/bin/sh

PATH=/bin:/sbin:/usr/bin:/usr/sbin
DATA=/tmp/data 
SYSTEM=/tmp/system 

echo Starting $0 `date`

mkdir -p ${DATA}
mkdir -p ${SYSTEM}

mount /dev/mmcblk2p9 ${DATA}
mount /dev/mmcblk2p10 ${SYSTEM}

if [ -d ${UPDATE_MP}/updates/system ]
then
   echo "Updating /system"
   cd ${UPDATE_MP}/updates/system
   if [ -f app/EbookReader.apk ]
   then
      echo "Reinstall EbookReader.apk with custom signature"
      rm -rf ${SYSTEM}/app/EbookReader.odex
      sed -i '/EbookReader/,/<\/package>/ { d }' ${DATA}/system/packages.xml
   fi
   cd -
   cp -rfp ${UPDATE_MP}/updates/system/* ${SYSTEM}
fi

if [ -f ${DATA}/system/packages.xml ]
then
   echo "Get rid of preferred activities in packages.xml"
   sed -i '/<preferred-activities>/,/<\/preferred-activities>/ { /preferred-activities/b; d }' ${DATA}/system/packages.xml

   echo "System signatures"
   sed -i '/uid.system/,/perms/{/uid.system/b;/perms/b;d}' ${DATA}/system/packages.xml
   rm ${DATA}/dalvik-cache/*
fi

umount ${DATA}
umount ${SYSTEM}

echo Done $0 `date`
