; Copyright (c) 2007 Ashish Kulkarni (mods by Nick Rapallo - March 2008)
;
; Permission is hereby granted, free of charge, to any person obtaining a
; copy of this software and associated documentation files (the "Software"),
; to deal in the Software without restriction, including without limitation
; the rights to use, copy, modify, merge, publish, distribute, sublicense,
; and/or sell copies of the Software, and to permit persons to whom the
; Software is furnished to do so, subject to the following conditions:

; The above copyright notice and this permission notice shall be included in
; all copies or substantial portions of the Software.

; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
; AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
; FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
; DEALINGS IN THE SOFTWARE.

!include "MUI.nsh"

;--------------------------------
;General

!define VERSION 1.8.2
!define GUI "PDFRead GUI ${VERSION}"
Name    "${GUI}"
OutFile "..\pdfread-gui.exe"
InstallButtonText "Convert"
AutoCloseWindow true
BrandingText "${GUI}"
Caption "${GUI}"

;--------------------------------
;Pages

Page custom GetConversionParameters

!insertmacro MUI_PAGE_INSTFILES
  
!insertmacro MUI_LANGUAGE "English"

ReserveFile "pdfread-gui.ini"
!insertmacro MUI_RESERVEFILE_INSTALLOPTIONS

;--------------------------------
;Variables
Var F4
Var F5
Var F6
Var F9
Var F10
Var F11
Var F12
Var F20
Var F15
Var F16
Var F17
Var F22
Var F21

;--------------------------------
;Installer Sections

Section "Main Section"
SectionEnd

!macro OptionalParam num param
  !insertmacro MUI_INSTALLOPTIONS_READ $R9 "pdfread-gui.ini" "Field ${num}" "State"
  Strcmp $R9 "" +2
  StrCpy $R2 '$R2 ${param} "$R9"'
!macroend

!macro DefaultParam num param def
  !insertmacro MUI_INSTALLOPTIONS_READ $R9 "pdfread-gui.ini" "Field ${num}" "State"
  Strcmp $R9 "" +3
  Strcmp $R9 "${def}" +2
  StrCpy $R2 '$R2 ${param} "$R9"'
!macroend

!macro Flag num name
  !insertmacro MUI_INSTALLOPTIONS_READ $R9 "pdfread-gui.ini" "Field ${num}" "State"
  IntCmpU $R9 0 +2
  StrCpy $R2 '$R2 ${name}'
!macroend

!macro Tip num tooltip
  FindWindow $3 "#32770" "" $HWNDPARENT
  IntOp $5 1199 + ${num}
  GetDlgItem $1 $3 $5
  ToolTips::Modern $1 0 "" "${tooltip}"
!macroend

Function .onInit
  !insertmacro MUI_INSTALLOPTIONS_EXTRACT "pdfread-gui.ini"

  ReadIniStr $F4 "\Program Files\PDFRead\pdfread.ini"  "Field 4"  "State"
  StrCmp $F4 "" nooptfile
  !insertmacro MUI_INSTALLOPTIONS_WRITE "pdfread-gui.ini" "Field 4"  "State" $F4
  ReadIniStr $F5  "\Program Files\PDFRead\pdfread.ini"  "Field 5"  "State"
  !insertmacro MUI_INSTALLOPTIONS_WRITE "pdfread-gui.ini" "Field 5"  "State" $F5
  ReadIniStr $F6  "\Program Files\PDFRead\pdfread.ini"  "Field 6"  "State"
  !insertmacro MUI_INSTALLOPTIONS_WRITE "pdfread-gui.ini" "Field 6"  "State" $F6
  ReadIniStr $F9  "\Program Files\PDFRead\pdfread.ini"  "Field 9"  "State"
  !insertmacro MUI_INSTALLOPTIONS_WRITE "pdfread-gui.ini" "Field 9"  "State" $F9
  ReadIniStr $F10 "\Program Files\PDFRead\pdfread.ini"  "Field 10" "State"
  !insertmacro MUI_INSTALLOPTIONS_WRITE "pdfread-gui.ini" "Field 10" "State" $F10
  ReadIniStr $F11 "\Program Files\PDFRead\pdfread.ini"  "Field 11" "State"
  !insertmacro MUI_INSTALLOPTIONS_WRITE "pdfread-gui.ini" "Field 11" "State" $F11
  ReadIniStr $F12 "\Program Files\PDFRead\pdfread.ini"  "Field 12" "State"
  !insertmacro MUI_INSTALLOPTIONS_WRITE "pdfread-gui.ini" "Field 12" "State" $F12
  ReadIniStr $F15 "\Program Files\PDFRead\pdfread.ini"  "Field 15" "State"
  !insertmacro MUI_INSTALLOPTIONS_WRITE "pdfread-gui.ini" "Field 15" "State" $F15
  ReadIniStr $F16 "\Program Files\PDFRead\pdfread.ini"  "Field 16" "State"
  !insertmacro MUI_INSTALLOPTIONS_WRITE "pdfread-gui.ini" "Field 16" "State" $F16
  ReadIniStr $F17 "\Program Files\PDFRead\pdfread.ini"  "Field 17" "State"
  !insertmacro MUI_INSTALLOPTIONS_WRITE "pdfread-gui.ini" "Field 17" "State" $F17
  ReadIniStr $F20 "\Program Files\PDFRead\pdfread.ini"  "Field 20" "State"
  !insertmacro MUI_INSTALLOPTIONS_WRITE "pdfread-gui.ini" "Field 20" "State" $F20
  ReadIniStr $F21 "\Program Files\PDFRead\pdfread.ini"  "Field 21" "State"
  !insertmacro MUI_INSTALLOPTIONS_WRITE "pdfread-gui.ini" "Field 21" "State" $F21
  ReadIniStr $F22 "\Program Files\PDFRead\pdfread.ini"  "Field 22" "State"
  !insertmacro MUI_INSTALLOPTIONS_WRITE "pdfread-gui.ini" "Field 22" "State" $F22
 nooptfile:
  Call GetParameters
  Pop  $R0
  StrCmp $R0 "" skip
  IfFileExists $R0 0 skip
  !insertmacro MUI_INSTALLOPTIONS_WRITE "pdfread-gui.ini" "Field 3" "State" $R0
skip:
FunctionEnd

Function GetConversionParameters
start:
  !insertmacro MUI_HEADER_TEXT "${GUI}" "Please enter the conversion details."
  !insertmacro MUI_INSTALLOPTIONS_INITDIALOG "pdfread-gui.ini"
  ; tooltips
  !insertmacro Tip 3  "This is the file that you want to use for conversion."
  !insertmacro Tip 4  "Browse to input file location."
  !insertmacro Tip 5  "Input document format."
  !insertmacro Tip 6  "The output filename (ignores file extension and uses selected Out Format)."
  !insertmacro Tip 7  "Browse to output file location."
  !insertmacro Tip 8  "Output document format. Profile REB1200 (use imp1); EBW1150 (imp2); generic (.oeb or .html)."
  !insertmacro Tip 9  "Title of the generated eBook. (Required)"
  !insertmacro Tip 10 "Author of the generated eBook. (Required)"
  !insertmacro Tip 11 "Category of the generated eBook."
  !insertmacro Tip 12 "Profile to use during conversion. (defaults can be overridden)."
  !insertmacro Tip 13 "The page layout mode. Use default to use the mode defined in the profile."
  !insertmacro Tip 14 "The command line arguments to pass to unpaper."
  !insertmacro Tip 15 "Start conversion from this page."
  !insertmacro Tip 16 "End conversion at this page."
  !insertmacro Tip 17 "Orientation of converted output (overrides default)."
  !insertmacro Tip 18 "Each page will be rendered at this DPI for dilation. Increase this to reduce the dilation effect."
  !insertmacro Tip 19 "All whitespace areas larger than this percentage will be cropped. Reduce if you want more aggressive cropping."
  !insertmacro Tip 20 "Target device horizontal size."
  !insertmacro Tip 21 "Target device vertical size."
  !insertmacro Tip 22 "Colorspace to use for output. (gray has max. 16 shades; rgb has max. 256 colors)."
  !insertmacro Tip 23 "Limit number of colors used in colorspace chosen (overrides default).  File size decreases as colors reduced."
  !insertmacro Tip 24 "Edge enhacement level. Increase for more sharper text, decrease for more smoother text."
  !insertmacro Tip 25 "Disable the creation of a Table of Contents (TOC)."
  !insertmacro Tip 26 "Disable the edge enhancement stage during conversion."
  !insertmacro Tip 27 "Disable the image dilation stage during conversion."
  !insertmacro Tip 28 "Each generated PNG will be optimized for maximum compression (can take some time)."
  !insertmacro Tip 29 "Disable the cropping stage during conversion."
  !insertmacro MUI_INSTALLOPTIONS_SHOW
  StrCmp $MUI_TEMP1 "cancel" finish

  !insertmacro MUI_INSTALLOPTIONS_READ $R3 "pdfread-gui.ini" "Field 4" "State"
  WriteIniStr "\Program Files\PDFRead\pdfread.ini" "Field 4" "State" $R3

  !insertmacro MUI_INSTALLOPTIONS_READ $R4 "pdfread-gui.ini" "Field 7" "State"
  !insertmacro MUI_INSTALLOPTIONS_READ $R5 "pdfread-gui.ini" "Field 10" "State"
  WriteIniStr "\Program Files\PDFRead\pdfread.ini" "Field 10" "State" $R5

  StrCpy $R2 '-p $R5 -i $R3 -t "$R4" '
  !insertmacro OptionalParam 8 '-a'
  !insertmacro OptionalParam 9 '-c'
  WriteIniStr "\Program Files\PDFRead\pdfread.ini" "Field 8" "State" $R9

  !insertmacro DefaultParam 5 '-o' 'default'
  WriteIniStr "\Program Files\PDFRead\pdfread.ini" "Field 5" "State" $R9

  !insertmacro OptionalParam 6 '-f'
  WriteIniStr "\Program Files\PDFRead\pdfread.ini" "Field 6" "State" $R9

  !insertmacro DefaultParam 11 '-m' 'default'
  WriteIniStr "\Program Files\PDFRead\pdfread.ini" "Field 11" "State" $R9

  !insertmacro DefaultParam 15 '-r' 'default'
  WriteIniStr "\Program Files\PDFRead\pdfread.ini" "Field 15" "State" $R9

  !insertmacro DefaultParam 20 '--colorspace' 'default'
  WriteIniStr "\Program Files\PDFRead\pdfread.ini" "Field 20" "State" $R9

  !insertmacro OptionalParam 21 '--colors'
  WriteIniStr "\Program Files\PDFRead\pdfread.ini" "Field 21" "State" $R9

  !insertmacro OptionalParam 13 '--first-page'
  !insertmacro OptionalParam 14 '--last-page'
  !insertmacro OptionalParam 18 '--hres'
  !insertmacro OptionalParam 19 '--vres'
  
  !insertmacro Flag 24 '--no-enhance'
  !insertmacro Flag 23 '--no-toc'
  !insertmacro Flag 25 '--no-dilate'
  !insertmacro Flag 26 '--optimize'
  !insertmacro Flag 27 '--no-crop'
  
  !insertmacro DefaultParam 16 '--dpi' '300'
  WriteIniStr "\Program Files\PDFRead\pdfread.ini" "Field 16" "State" $R9

  !insertmacro DefaultParam 17 '--crop-percent' '2.0'
  WriteIniStr "\Program Files\PDFRead\pdfread.ini" "Field 17" "State" $R9

  !insertmacro DefaultParam 22 '--edge-level' '5'
  WriteIniStr "\Program Files\PDFRead\pdfread.ini" "Field 22" "State" $R9
  
  !insertmacro OptionalParam 12 '-u'
  WriteIniStr "\Program Files\PDFRead\pdfread.ini" "Field 12" "State" $R9
  
  !insertmacro MUI_INSTALLOPTIONS_READ $R3 "pdfread-gui.ini" "Field 3" "State"
  Strcpy $R2 '$R2 "$R3"'
  Exec '"$EXEDIR\pdfread-run.cmd" $R2'
  Goto start
finish:
FunctionEnd

Function GetParameters
 
  Push $R0
  Push $R1
  Push $R2
  Push $R3
  
  StrCpy $R2 1
  StrLen $R3 $CMDLINE
  
  ;Check for quote or space
  StrCpy $R0 $CMDLINE $R2
  StrCmp $R0 '"' 0 +3
    StrCpy $R1 '"'
    Goto loop
  StrCpy $R1 " "
  
  loop:
    IntOp $R2 $R2 + 1
    StrCpy $R0 $CMDLINE 1 $R2
    StrCmp $R0 $R1 get
    StrCmp $R2 $R3 get
    Goto loop
  
  get:
    IntOp $R2 $R2 + 1
    StrCpy $R0 $CMDLINE 1 $R2
    StrCmp $R0 " " get
    StrCpy $R0 $CMDLINE "" $R2
  
  Pop $R3
  Pop $R2
  Pop $R1
  Exch $R0
 
FunctionEnd