@ECHO off

REM SET FILES_TO_PATCH=libnickel.so.1.0.0 librmsdk.so.1.0.0

SETLOCAL ENABLEDELAYEDEXPANSION
SET the7zipexe=%CD%\tools\7za920\7za.exe
SET thepatchexe=%CD%\tools\pa32lsb.exe

SET projectname=%~n0
REM --- Do a simple patch? Or unpack first?
IF NOT "x%projectname:_unpack=%"=="x%projectname%"  (
 SET projectname=%projectname:_unpack=%
 SET unpackFW=true
)

SET sourcepath=%CD%\%projectname%_source
SET targetpath=%CD%\%projectname%_target
SET thekobopath=%targetpath%\usr\local\Kobo

REM --- Unpack if this is wanted
IF "%unpackFW%"=="true" (
  IF exist "%sourcepath%" (
  SET currentPath=%CD%
  CD "%sourcepath%"
  ECHO unpack ... %CD%
  "%the7zipexe%" e -y *.zip KoboRoot.tgz
  IF ERRORLEVEL 1 GOTO errorUNPACK
  "%the7zipexe%" e -y KoboRoot.tgz
  IF ERRORLEVEL 1 GOTO errorUNPACK
  DEL KoboRoot.tgz

for %%i in (%sourcepath%\*.patch) do (
  set filetoextract=%%~ni
  "%the7zipexe%" e -r -y -ttar KoboRoot.tar !filetoextract!
IF ERRORLEVEL 1 GOTO errorUNPACK
 )
  DEL KoboRoot.tar
  CD %currentPath%
) ELSE (GOTO errorNOSOURCEPATH)
)
REM --- Unpack end


REM ------------ clean up 
DEL /s /f /q "%targetpath%"
RD /S /Q "%targetpath%"
md "%thekobopath%"

REM ------------- patch files


for %%i in (%sourcepath%\*.patch) do (
  set patchfile=%%~i
  set inputfile=%sourcepath%\%%~ni
  set outputfile=%thekobopath%\%%~ni
if exist "!inputfile!" (
  ECHO //////////////////////////////////////////////
  ECHO //                    Patching start
  ECHO //////////////////////////////////////////////
  "%thepatchexe%" -p "!patchfile!" -i "!inputfile!" -o "!outputfile!"
  IF ERRORLEVEL 1 (
     SET errorf=%%i
    GOTO patchError
  )
  ECHO //////////////////////////////////////////////
  ECHO //                    Patching end
  ECHO //////////////////////////////////////////////
)
)

REM ------------- compress
CD %targetpath%
REM --- clean up
IF EXIST KoboRoot.tar DEL KoboRoot.tar
IF EXIST KoboRoot.tgz DEL KoboRoot.tgz

REM ------------- make tar
"%the7zipexe%" a KoboRoot.tar -ttar  * -r
IF ERRORLEVEL 1 GOTO errorTAR

REM ------------- make tgz
"%the7zipexe%" a KoboRoot.tgz -tgzip  KoboRoot.tar
IF ERRORLEVEL 1 GOTO errorTGZ

REM ------------- clean up
DEL KoboRoot.tar
RD /S /Q usr

goto byby





REM ------------- handle errors

:errorNOSOURCEPATH
ECHO ERROR: cannot find %sourcepath% 
set problems=TRUE
goto byby

:errorUNPACK
ECHO ERROR: problems while unpacking
ECHO Did you copy kobo-update-X.X.X.zip to %sourcepath%?
set problems=TRUE
goto byby


:patchError
ECHO ERROR processing %errorf%
set problems=TRUE
goto byby

:errorTAR
ECHO ERROR while creating KoboRoot.tar
set problems=TRUE
goto byby

:errorTGZ
ECHO ERROR while creating KoboRoot.tgz
set problems=TRUE
goto byby

:byby
if  "%problems%" NEQ "TRUE" ECHO Everything seems to be O.K.!
PAUSE
