#include <stdio.h>
#include <stdlib.h>    // malloc, free, atoi
#include <string.h>   // memset, memcpy
#include <unistd.h>  // usleep
#include <fcntl.h>  // open, close, write
#include <time.h>  // time
#include <sys/ioctl.h>   // ioctl
#include <sys/time.h>   // gettime
#include <sys/mman.h>  // mmap, munmap
#include <linux/fb.h> // screeninfo
#include <pthread.h>

#define WIDTH 600
#define HEIGHT 800
#define STRIDE 608
#define TOUCH_SCREEN "/dev/input/event3"
#define UP 0
#define DOWN 1
#define xSIZE     800
#define ySIZE 600
#define BLACK -16
#define FPS 10 // max frames/sec

enum eupd_op { EUPD_OPEN,EUPD_CLOSE,EUPD_UPDATE };
typedef unsigned char u8;
typedef unsigned int u32;

// function prototypes
inline void setpx(int,int,int);
int eupdate(int);
int getmsec(void);
// global var7
u32 mpu=200;      // msec/update
u8 *fb0=NULL;   // framebuffer pointer
int fdFB=0;    // fb0 file descriptor
u32 fs=0;     // fb0 stride
u32 MX=0;    // xres (visible)
u32 MY=0;   // yres (visible)
u8 blk=0;  // black
u8 wht=0; // white
u8 pb=0; // pixel bits


main(void)
{
  unsigned char event_buffer[16];
  int touch_screen_fd = 0;
  /* First finger variables */
  int finger = UP;
  int x = 300;
  int y = 400;

  /* Second finger variables */
  int finger2 = UP;
  int x2 = 0;
  int y2 = 0;
  int f2_mode = 0;

  int i = 0;
  int j = 0;

  /* Threads */
  pthread_t updater = 0;
  int running = 1;

  int sync = 0;

  touch_screen_fd = open(TOUCH_SCREEN, O_RDONLY);
  if(touch_screen_fd == -1) {
    fprintf(stderr, "Error: Could not open touch screen.\n");
    exit(EXIT_FAILURE);
  }



  int a, tn, cat;
  struct fb_var_screeninfo screeninfo;
  fdFB=open("/dev/fb0",O_RDWR); // eink framebuffer
  short xq, yq, count, Maxiters;
  long double zr=1.0, zi=1.0, cr=1.0, b, ci=1.0, s;
  s =0;
  short lef2=300, down2=300, up2=300, righ2=500;
  long double bottom = 1.50;
  long double right= 2.50;
  long double top= 1.50;
  long double left=1.50;
//   printf("%f %f %f %f",lef,righ, up, down);
  long double rsquared=10, isquared=1.0;
  Maxiters = 200;
  ioctl(fdFB,FBIOGET_VSCREENINFO,&screeninfo);
  MX=screeninfo.xres;  // max X+1
  MY=screeninfo.yres; // max Y+1
  pb=screeninfo.bits_per_pixel;     // pixel bits
  fs=screeninfo.xres_virtual*pb/8; // fb0 stride
  blk=pb/8-1; // black
  wht=~blk;  // white
  fb0=(u8 *)mmap(0,MY*fs,PROT_READ|PROT_WRITE,MAP_SHARED,fdFB,0); // map fb0
  eupdate(EUPD_OPEN); // open fb0 update proc
  eupdate(EUPD_UPDATE);    // update display
  a=0;
  b=1;
  s=0;
  b=0;
FRAC:
  b+=0.1;
  for (yq =0; yq <ySIZE; yq++)
  {
    for (xq = xSIZE; xq>1; xq--)
    { 

      zr = 0;
      zi = 0;
      cr = left + xq * ((right + left)*-1) / xSIZE;

      ci = top+ yq * ((top+bottom)*-1) / ySIZE;
      //         printf("%i", ci);
      rsquared = zr * zr;
      isquared = zi * zi;

      for (count = 0; rsquared + isquared <= 4.0
           && count < Maxiters; count++)
      {
        zi = zr * zi * 2;
        zi += ci;

        zr = rsquared - isquared;
        zr += cr;

        rsquared = zr *zr;
        isquared = zi * zi;
        //          a=rsquared+isquared;
        //            printf("%f",a);
      }

      if (rsquared + isquared < 4.0) {
        setpx(yq,xq,0);
      } else {
        cat = count % 5;
        cat *= 16;
        cat +=1;
        setpx(yq,xq,cat);
      }
    }
    eupdate(EUPD_UPDATE);
  }
  s+=1;


  /* Loop through touch screen input, writing pretty things to the screen */
  while(1==1) {
    //     printf("56");
    read(touch_screen_fd, event_buffer, 16);
    if(event_buffer[0x08] == 0x03) {
      switch(event_buffer[0x0A]) {
      case 0x2F:
        /* When f2_mode is nonzero, data is treated as being for
            the second finger */
        f2_mode = event_buffer[0x0C];
        break;
      case 0x35:
        /* X Coordinate change */
        if(!f2_mode) {
          x = (WIDTH * (event_buffer[0x0C] + (event_buffer[0x0D] << 8))) / 0x1000;
        }
        else {
          x2 = (WIDTH * (event_buffer[0x0C] + (event_buffer[0x0D] << 8))) / 0x1000;
        }
        break;
      case 0x36:
        /* Y Coordinate change */
        if(!f2_mode) {
          y = (HEIGHT * (event_buffer[0x0C] + (event_buffer[0x0D] << 8))) / 0x1000;
        }
        else {
          y2 = (HEIGHT * (event_buffer[0x0C] + (event_buffer[0x0D] << 8))) / 0x1000;
        }
        break;
      case 0x39:
        /* Finger up / down */
        if(event_buffer[0x0C] == 0x00) {
          //                      printf("Finger 1 down.\n");
          finger = DOWN;
        }
        else if(event_buffer[0x0C] == 0x01) {
          //                    printf("Finger 2 down.\n");
          finger2 = DOWN;
        }
        else {
          if(finger2 == DOWN) {
            finger2 = UP;
            //                       printf("Finger 2 up.\n");
          }
          else {
            finger = UP;
            //                       printf("Finger 1 up.\n");
          }

        }
        break;
      default:
        break;
      }
    }
    if(event_buffer[0x08] == 0x00) {
      sync = 1;
    }
    if(sync) { /* We have recieved a sync */

      /* If finger 1 is down, draw for it */
      if(finger == DOWN) {
        for(i = -2; i < 3; i++) {
          for(j = -2; j < 3; j++) {
            if(x + i >= 0 && x + i < 600 && y + j >= 0 && y + j < 800) {
              //                       frame_buffer[(x + i) + STRIDE * (y + j)] = 255;
//                             printf("%i %i \n",x,y);
            }
          }
        }
        if(x<50 && y<50) {
        goto END;
        }
        if(x>550 && y<50) {
        s-=5;
        left =( lef2 / 200.0)*s;
        right =(righ2 / 200.0)*s;
        top =( up2 / 200.0)*s;
        bottom =( down2 / 200.0)*s;
        finger=UP;
        //            return 0;
        system("eips -c -f");
        goto FRAC;
        }
    //    system("eips -c -f");
  //      finger=UP;
   //     goto FRAC;
        s +=3;
        a+=1;
        b+=4;
        x=300-x;
        y=300-y;
        up2+=x*3;
        down2-=x*3;
        lef2+=y*4;
        righ2-=y*4;
        left =( lef2 / 200.0)/s;
        right =(righ2 / 200.0)/s;
        top =( up2 / 200.0)/s;
        bottom =( down2 / 200.0)/s;
        finger=UP;
        //            return 0;
        system("eips -c -f");
        goto FRAC;
      }

      /* If finger 2 is down, draw for it */
      if(finger2 == DOWN) {
        for(i = -2; i < 3; i++) {
          for(j = -2; j < 3; j++) {
            if(x2 + i >= 0 && x2 + i < 600 && y2 + j >= 0 && y2 + j < 800) {
              //                          frame_buffer[(x2 + i) + STRIDE * (y2 + j)] = 255;
            }
          }
        }
      }

    }
    sync = 0;
  }

  running = 0;

END:


  /* Resume the Kindle framework */


  return EXIT_SUCCESS;


  eupdate(EUPD_CLOSE);
  munmap(fb0,fs*(MY+1)); // unmap fb0
  close(fdFB);          // close fb0
  // free();
  return 0;
}


//===============================
// eupdate - eink update display
// op (open, close, update)
//-------------------------------
int eupdate(int op) {
  static int fdUpdate=-1;
  if (EUPD_OPEN==op) {
    fdUpdate=open("/proc/eink_fb/update_display",O_WRONLY);
  } else if (EUPD_CLOSE==op) {
    close(fdUpdate);
  } else if (EUPD_UPDATE==op) {
    if (-1==fdUpdate) {
      system("eips ''");
    } else {
      write(fdUpdate,"1\n",2);
    }
  } else {
    return -1;    // bad op code
  }
  return fdUpdate;
}


//========================================
// setpx - draw pixel using ordered dither
// x,y: screen coordinates, c: color(0-64).
// (This works on all eink kindle models.)
//----------------------------------------
inline void setpx(int x,int y,int c) {
  static int dt[64] = { 1,33,9,41,3,35,11,43,49,17,57,25,51,19,59,27,13,45,5,
                        37,15,47,7,39,61,29,53,21,63,31,55,23,4,36,12,44,2,34,10,42,52,20,60,28,50,
                        18,58,26,16,48,8,40,14,46,6,38,64,32,56,24,62,30,54,22
                      }; // dither table
  fb0[pb*x/8+fs*y]=((128&(c-dt[(7&x)+8*(7&y)]))/128*(blk&(240*(1&~x)|
                    15*(1&x)|fb0[pb*x/8+fs*y])))|((128&(dt[(7&x)+8*(7&y)]-c))/128*wht|
                        (blk&((240*(1&x)|15*(1&~x))&fb0[pb*x/8+fs*y]))); // geekmaster formula 42
}


//====================================
// getmsec - get msec since first call
// (tick counter wraps every 12 days)
//------------------------------------
int getmsec(void) {
  int tc;
  static int ts=0;
  struct timeval tv;
  gettimeofday(&tv,NULL);
  tc=tv.tv_usec/1000+1000*(0xFFFFF&tv.tv_sec);
  if (0==tc) {
    ts=tc;
  }
  return tc-ts;
}