#include <iostream>
#include <errno.h>
#include <sys/ioctl.h>
using namespace std;

int CM_USB_Plug_IN = 108; // 0x6C

int main()
{
    int pointer;
    int code;
    int ioctl_res;
    const char* usb_dev_file = "/dev/ntx_io";
    const char* usb_dev_mode = "r+";
    FILE* file = fopen(usb_dev_file, usb_dev_mode);
    
    if (file == NULL)
    {
        cerr << "fopen failed for file \"" << usb_dev_file << "\" with mode \"" 
             << usb_dev_mode << "\", errno: " << errno;
        code = 2;
    }
    else
    {
        ioctl_res = ioctl(fileno(file), CM_USB_Plug_IN, &pointer);
        
        if (ioctl_res != -1)
        {
            if (pointer == 0)
            {
                cout << "USB device is not used.";
                code = 1;
            }
            else
            {
                cout << "USB device is under use.";
                code = 0;
            }
        }
        else
        {
            cerr << "ioctl failed for file \"" << usb_dev_file 
                 << "\" with signal " << CM_USB_Plug_IN 
                 << ", errno: " << errno;
        }
        
        fclose(file);
    }
    
    cout << "\n";
    return code;
}

