package eu.smidovi.david.methodtools;

public class StringUtil {
    
    /**
     * Escapes in the character string.
     * <p>
     * Converts the following character into the escape sequence.
     * <ul>
     * <li>HT -> "\t"</li>
     * <li>LF -> "\n"</li>
     * <li>CR -> "\r"</li>
     * <li>FF -> "\f"</li>
     * </ul>
     * Processes neither a single quart nor a double quart.
     *
     * @param str 
     *   Character string of escape processing object
     * @return 
     *   Character string after escape is processed
     */
    public static String escape(final String str) {
        
        StringBuffer escapedStr = new StringBuffer();
        
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);

            switch (c) {
            case '\t':
                escapedStr.append("\\t");
                break;
            case '\n':
                escapedStr.append("\\n");
                break;
            case '\f':
                escapedStr.append("\\f");
                break;
            case '\r':
                escapedStr.append("\\r");
                break;
            case '\\':
                escapedStr.append("\\\\");
                break;
            case '|':
                escapedStr.append("\\|");
                break;
            case '*':
                escapedStr.append("\\*");
                break;
            case '^':
                escapedStr.append("\\^");
                break;
            default:
                escapedStr.append(c);
            }
        }

        return escapedStr.toString();
    }

    /**
     * Unescapes in the character string.
     * <p>
     * Converts the following escape sequence into the character. 
     * <ul>
     * <li>"\t" -> HT</li>
     * <li>"\n" -> LF</li>
     * <li>"\r" -> CR</li>
     * <li>"\f" -> FF</li>
     * <li>"\"" -> "</li>
     * <li>"\'" -> '</li>
     * </ul>
     * Note the point that doesn't become it in a complete inversion of 
     * espace().
     *
     * @param str 
     *   Character string where to be unescaped
     * @return 
     *   Character string after it unescapes 
     */
    public static String unescape(final String str) {
        
        StringBuffer unescaped_str = new StringBuffer();

        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            
            char c = str.charAt(i);
            
            if (c == '\\') {
                ++count;
                if (count % 2 == 0) {
                    unescaped_str.append(c);
                }
            } else {
                if ((count > 0) && (count % 2 != 0)) {
                    count = 0;
                    if (c == 't') {
                        unescaped_str.append('\t');
                    } else if (c == 'n') {
                        unescaped_str.append('\n');
                    } else if (c == 'f') {
                        unescaped_str.append('\f');
                    } else if (c == 'r') {
                        unescaped_str.append('\r');
                    } else if (c == '\"') {
                        unescaped_str.append('\"');
                    } else if (c == '\'') {
                        unescaped_str.append('\'');
                    } else {
                        unescaped_str.append(c);
                    }
                } else {
                    count = 0;
                    unescaped_str.append(c);
                }
            }
        }
        
        return unescaped_str.toString();
    }
}
