package eu.smidovi.david.methodtools;

import java.io.File;
import java.io.IOException;
import java.util.Scanner;

import org.gjt.jclasslib.io.ClassFileReader;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.InvalidByteCodeException;

import ee.ioc.cs.jbe.browser.codeedit.ClassSaver;

public class ImportMethod {

	public static void main(String[] args) {
		if (args.length < 1) {
			System.err.println("Usage: im <class file> <method name> [<method signature>]");
			System.err.println("Bytecode dump is expected on the standard input");
			System.exit(1);
		}
        File file = new File(args[0]);
        ClassFile classFile;
        String method = "<init>";
        String signature = "";
		try {
			classFile = ClassFileReader.readFromFile(file);
	        if (args.length > 1) method = args[1];
	        if (args.length > 2) signature = args[2];
	        int methodIndex = classFile.getMethodIndex(method, signature);
	        if (methodIndex == -1) {
	        	for (int idx=0; idx < classFile.getMethods().length; idx++) {
					if (classFile.getMethods()[idx].getName().equals(method)) {
						methodIndex = idx;
						break;
					}
				}
	            if (methodIndex == -1) {
	            	System.err.println("Method not found");
	            	System.exit(1);
	            }
	        }
	        
	        StringBuffer inp = new StringBuffer();
	        Scanner sc = new Scanner(System.in);
	        while(sc.hasNextLine()) {
	        	inp.append(sc.nextLine());
	        	inp.append(System.getProperty("line.separator"));
	        }
	        sc.close();
	        String methodBody = inp.toString();
	        ClassSaver cs = new ClassSaver(ClassSaver.SAVE_CODE, args[0], methodBody, methodIndex);
	        cs.saveCode(args[0], methodBody, methodIndex);
		} catch (InvalidByteCodeException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

}
