package eu.smidovi.david.methodtools;
import java.io.File;
import java.io.IOException;

import org.gjt.jclasslib.io.ClassFileReader;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.structures.MethodInfo;
import org.gjt.jclasslib.structures.attributes.CodeAttribute;

import ee.ioc.cs.jbe.browser.codeedit.*;

public class ExportMethod {

	public static void main(String[] args) {
		if (args.length < 1) {
			System.err.println("Usage: dm <class file> <method name> [<method signature>]");
			System.err.println("Bytecode dump will be written on the standard output");
			System.exit(1);
		}
        File file = new File(args[0]);
        ClassFile classFile;
        String method = "<init>";
        String signature = "";
		try {
			classFile = ClassFileReader.readFromFile(file);
	        if (args.length > 1) method = args[1];
	        if (args.length > 2) signature = args[2];
	        int methodIndex = classFile.getMethodIndex(method, signature);
	        if (methodIndex == -1) {
	        	for (int idx=0; idx < classFile.getMethods().length; idx++) {
					if (classFile.getMethods()[idx].getName().equals(method)) {
						methodIndex = idx;
						break;
					}
				}
	            if (methodIndex == -1) {
	            	System.err.println("Method not found");
	            	System.exit(1);
	            }
	        }
	        
	        MethodInfo mi = classFile.getMethods()[methodIndex];
	        CodeAttribute ca = (CodeAttribute)mi.findAttribute(CodeAttribute.class);
	        if (ca != null) {
	        	CodeGenerator cg = new CodeGenerator(); 
	        	System.out.println(cg.makeMethod(ca.getCode(), classFile));
	        }
		} catch (InvalidByteCodeException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
}
