#!/bin/sh

root=/mnt/onboard/.kobo/progs/usbnet

PLATFORM=ntx508
if [ "$DEVICE" == "TOUCH" ]; then
    PLATFORM=freescale
fi

if [ -f /var/run/dropbear.pid ]
then
    kill `cat /var/run/dropbear.pid`
    ifconfig usb0 down
    rmmod g_ether
    rmmod arcotg_udc
else
    driver_root=/drivers/$PLATFORM/usb/gadget
    insmod $driver_root/arcotg_udc.ko
    insmod $driver_root/g_ether.ko host_addr=46:0d:9e:67:69:eb dev_addr=46:0d:9e:67:69:ec
    ifconfig usb0 192.168.2.101
    if [ "$?" -ne "0" ] ; then
        echo "usb network error!" > $root/dropbear.log
        exit 1
    fi
    [ ! -e /usr/libexec/sftp-server ] && (mkdir -p /usr/libexec; ln -sf $root/sftp-server /usr/libexec/sftp-server)
    $root/dropbear -E -r $root/host.key.rsa -d $root/host.key.dss > $root/dropbear.log 2>&1
fi
