#!/bin/sh
# ==== nickel variant of the launcher
# set variables
export ROOT=/mnt/onboard/.kobo/vlasovsoft
cd $ROOT
. ./setvars.sh

# make the temporary directory for Qt
mkdir -p $TMPDIR

# make fifo
mkfifo $VLASOVSOFT_FIFO

# run launcher
killall -STOP nickel
echo 0 > /sys/class/graphics/fb0/rotate
$ROOT/launcher -qws -stylesheet $STYLESHEET
echo 3 > /sys/class/graphics/fb0/rotate
killall -CONT nickel

# remove fifo
rm $VLASOVSOFT_FIFO

if [ $DEVICE == TOUCH -o $DEVICE == MINI ]; then
    sleep 1s
    # press "Home" button to see the main screen
    # (works on Mini, Touch models)
    dd obs=32 if=$ROOT/homekey of=/dev/input/event0
fi
