#!/bin/sh
kbmenudir=/mnt/onboard/.kobo/kbmenu
sh $kbmenudir/onstart/feedfmon.sh
( usleep 400000; /etc/init.d/on-animator.sh ) &

(
/usr/local/Kobo/pickel disable.rtc.alarm

if [ ! -e /etc/wpa_supplicant/wpa_supplicant.conf ]; then
  cp /etc/wpa_supplicant/wpa_supplicant.conf.template /etc/wpa_supplicant/wpa_supplicant.conf
fi

echo 1 > /sys/devices/platform/mxc_dvfs_core.0/enable

/sbin/hwclock -s -u
) &

export QWS_KEYBOARD=imx508kbd:/dev/input/event0

export NICKEL_HOME=/mnt/onboard/.kobo
export LD_LIBRARY_PATH=/usr/local/Kobo

export QT_PLUGIN_PATH=/usr/local/Kobo/plugins

if [ -e /usr/local/Kobo/plugins/gfxdrivers/libimxepd.so ]; then
  export QWS_DISPLAY=imxepd
else
  export QWS_DISPLAY=Transformed:imx508:Rot90
  export QWS_MOUSE_PROTO="tslib_nocal:/dev/input/event1"
fi

geometrybefore=$(fbset -s | grep 'geometry')

/usr/local/Kobo/hindenburg &
# [ $PLATFORM != freescale ] && rm -rf /dev/mmcblk1* && udevadm trigger &
if [ -e /root/screenInv.so ]; then
  LD_PRELOAD=/root/screenInv.so /usr/local/Kobo/nickel -qws -skipFontLoad
else
  /usr/local/Kobo/nickel -qws -skipFontLoad
fi

echo 0 > /sys/class/graphics/fb0/rotate
geometryafter=$(fbset -s | grep 'geometry')

if [ "$PRODUCT" == "dragon" ]; then
  sh $kbmenudir/kobomenu.sh -autoselectafter=0
fi

if [ "$geometrybefore" != "$geometryafter" ]; then
reboot
fi
