#!/bin/sh

// check if there is ONE argument
if [[ $# != 1 ]]; then
  exit
fi

root=/mnt/onboard/.kobo/kbmenu
. $root/onstart/exp_block

scriptsdir=$1

if [ -e $scriptsdir/help.txt ]; then
  infooption="info:help "
else
  infooption=""
fi

# ---------------------- function: set options
setoptions() {
  OIFS="$IFS"
  IFS=$'\n'
# ---------------------- find scripts
  scriptlist=""
  textlist=""
  for file in `find $scriptsdir -maxdepth 1 -name '*.sh'`
  do
    bar=${file/ /}
    bar=${bar/-/}
    if [ "$file" == "$bar" ]; then
      filename=$(basename $file)
      case $filename in
        enable*.sh)
          if [ $MODULE_LOADED -eq 0 ]; then
            scriptlist="$scriptlist $(basename $file):execute.png"
            textlist="$textlist $(basename $file):help.png"
          fi
          ;;
        disable*.sh)
          if [ $MODULE_LOADED -ge 1 ]; then
            scriptlist="$scriptlist $(basename $file):execute.png"
            textlist="$textlist $(basename $file):help.png"
          fi
          ;;
        *)
          scriptlist="$scriptlist $(basename $file):execute.png"
          textlist="$textlist $(basename $file):help.png"
          ;;
      esac
    fi
  done
  IFS="$OIFS"
# ---------------------- create optionlist

  if [ "$scriptlist" != "" ]; then
    optionlist="exec/read:toggle.png"
    scriptlist=$(echo $scriptlist | xargs -n1 | sort | xargs)
    textlist=$(echo $textlist | xargs -n1 | sort | xargs)
    if [ "$toggleoption" == "execute_mode" ]; then
      optionlist="$optionlist $scriptlist"
    else
      optionlist="$optionlist $textlist"
    fi
  fi
}


# ---------------------- start the menu loop
toggleoption="execute_mode"
while [ "$menu" != "EXIT" ]; do
  MODULE_LOADED=`lsmod | grep -c g_file_storage`
  if [ $MODULE_LOADED -eq 0 ]; then
    statusinfo="USB support is currently not enabled"
  else
    statusinfo="USB support is enabled"
  fi
  setoptions
  menu=$($root/kobomenu -infolines=2 "-infotext=$statusinfo" $infooption$optionlist return:arrowup -qws)
  case "$menu" in
    info)
      sh $root/kbmessage.sh "-f $scriptsdir/help.txt"
      ;;
    exec/read)
      optionlist="exec/read:toggle.png"
      if [ $toggleoption == "execute_mode" ]; then
        optionlist="$optionlist $textlist"
        toggleoption="read_mode"
      else
        optionlist="$optionlist $scriptlist"
        toggleoption="execute_mode"
      fi
      ;;
    return)
      menu="EXIT";;
    *.sh)
      if [ "$toggleoption" == "execute_mode" ]; then
        sh $scriptsdir/$menu
      else
        sh $root/kbmessage.sh "-f $scriptsdir/$menu"
      fi
      ;;
    *)
      sh $root/onstart/scriptmenu.sh "$scriptsdir/$menu"
#
      ;;
  esac
done

