#!/bin/sh


kbroot=/mnt/onboard/.kobo/kbmenu
fmondir=$kbroot/tools
fmonshdir=$kbroot/fmonsh
pngdir=/mnt/onboard/kbmenupngs

if [ -e $fmondir/fmon ]; then
  OIFS="$IFS"
  IFS=$'\n'
  for file in `find $fmonshdir -maxdepth 1 -name '*.sh'`
  do
    filename=$(basename $file)
    filename="${filename%.*}"
    if [ -e $pngdir/$filename\.png ] &&\
      [ $($kbroot/tools/sqlite3 /mnt/onboard/.kobo/KoboReader.sqlite "select ContentID from content where ContentID = 'file://$pngdir/$filename.png'") != "" ]
    then
      $fmondir/fmon $pngdir/$filename.png $fmonshdir/$filename.sh >> $fmondir/fmon.log.txt 2>&1 &
    fi
  done
  IFS="$OIFS"
fi

if [ -e $pngdir/toggle_nightmode.png ] && [ -e /mnt/onboard/.kobo/nightmode.sh ]; then
  $fmondir/fmon $pngdir/toggle_nightmode.png /mnt/onboard/.kobo/nightmode.sh >> /mnt/onboard/.kobo/fmon/fmon.log.txt 2>&1 &
fi




