@ECHO OFF
SET sourcepath=3.2.0_source
SET targetpath=3.2.0_target
SET the7zipexe=%CD%\tools\7za920\7za.exe

REM ------------- patch files

SET sourcepath=%CD%\%sourcepath%
for %%i in (%sourcepath%\conf_*.txt) do (
  ECHO --------------------------------------------------------------------
  ECHO --------------------------------------------------------------------
  tools\patchit.exe "%%i" silent=false
  IF ERRORLEVEL 1 (
     SET errorf=%%i
    GOTO patchError
  )
)


REM ------------- compress
CD %targetpath%
REM --- clean up
IF EXIST KoboRoot.tar DEL KoboRoot.tar
IF EXIST KoboRoot.tgz DEL KoboRoot.tgz

REM ------------- make tar
"%the7zipexe%" a KoboRoot.tar -ttar  * -r  -x!_*
IF ERRORLEVEL 1 GOTO errorTAR

REM ------------- make tgz
"%the7zipexe%" a KoboRoot.tgz -tgzip  KoboRoot.tar
IF ERRORLEVEL 1 GOTO errorTGZ

REM ------------- clean up
DEL KoboRoot.tar
RD /S /Q usr

goto byby

REM ------------- handle errors

:patchError
ECHO ERROR processing %errorf%
set problems=TRUE
goto byby

:errorTAR
ECHO ERROR while creating KoboRoot.tar
set problems=TRUE
goto byby

:errorTGZ
ECHO ERROR while creating KoboRoot.tgz
set problems=TRUE
goto byby

:byby
if  "%problems%" NEQ "TRUE" ECHO Everything seems to be O.K.!
PAUSE
