#include <sys/types.h>
#include <stdio.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "ntx_io.h"

int main(int argc,char **argv)
{
 int ntx_io;
 unsigned long retval,pointer,value;
 struct ebook_device_info info;

 ntx_io=open("/dev/ntx_io",O_RDWR);

 // CM_SD_IN - SD card is inserted?

 retval=ioctl(ntx_io, CM_SD_IN, &pointer);
 printf("ioctl(ntx_io,CM_SD_IN)               = %d; returned %ld\n",retval,pointer);

 // CM_SD_PROTECT - SD card is protected?

 retval=ioctl(ntx_io, CM_SD_PROTECT, &pointer);
 printf("ioctl(ntx_io,CM_SD_PROTECT)          = %d; returned %ld\n",retval,pointer);


 // AC_IN - USB is inserted?

 retval=ioctl(ntx_io, AC_IN, &pointer);
 printf("ioctl(ntx_io,AC_IN)                  = %d; returned %ld\n",retval,pointer);

 // CM_USB_Plug_IN - USB is inserted?

 retval=ioctl(ntx_io, CM_USB_Plug_IN, &pointer);
 printf("ioctl(ntx_io,CM_USB_Plug_IN)         = %d; returned %ld\n",retval,pointer);

 // CM_USB_AC_STATUS - (always 0)?

 retval=ioctl(ntx_io, CM_USB_AC_STATUS, &pointer);
 printf("ioctl(ntx_io,CM_USB_AC_STATUS)       = %d; returned %ld\n",retval,pointer);

 // CM_GET_BATTERY_STATUS - battery charge?

 retval=ioctl(ntx_io, CM_GET_BATTERY_STATUS, &pointer);
 printf("ioctl(ntx_io,CM_GET_BATTERY_STATUS)  = %d; returned %ld\n",retval,pointer);


 // CM_RTC_WAKEUP_FLAG - Woken by RTC?

 retval=ioctl(ntx_io, CM_RTC_WAKEUP_FLAG, &pointer);
 printf("ioctl(ntx_io,CM_RTC_WAKEUP_FLAG)     = %d; returned %ld\n",retval,pointer);


 // CM_ROTARY_STATUS - Status of rotary encoder (not in this hardware)?

 retval=ioctl(ntx_io, CM_ROTARY_STATUS, &pointer);
 printf("ioctl(ntx_io,CM_ROTARY_STATUS)       = %d; returned %ld\n",retval,pointer);

 // CM_GET_KEY_STATUS - Status of key?

 retval=ioctl(ntx_io, CM_GET_KEY_STATUS, &pointer);
 printf("ioctl(ntx_io,CM_GET_KEY_STATUS)      = %d; returned %ld\n",retval,pointer);

 // CM_GET_WHEEL_KEY_STATUS - (always = 0)?

 retval=ioctl(ntx_io, CM_GET_WHEEL_KEY_STATUS, &pointer);
 printf("ioctl(ntx_io,CM_GET_WHEEL_KEY_STATUS)= %d; returned %ld\n",retval,pointer);


 // CM_CONTROLLER - Which controller (always = 2)?

 retval=ioctl(ntx_io, CM_CONTROLLER, &pointer);
 printf("ioctl(ntx_io,CM_CONTROLLER)          = %d; returned %ld\n",retval,pointer);

 // CM_DEVICE_MODULE - Hardware type?

 retval=ioctl(ntx_io, CM_DEVICE_MODULE, &pointer);
 printf("ioctl(ntx_io,CM_DEVICE_MODULE)       = %d; returned %ld\n",retval,pointer);

 // CM_DEVICE_INFO - Hardware type?

 retval=ioctl(ntx_io, CM_DEVICE_INFO, &info);
 printf("ioctl(ntx_io,CM_DEVICE_INFO)        = %d\n",retval);
 printf("     char device_name = %d\n",info.device_name);
 printf("     char cpu         = %d\n",info.cpu        );
 printf("     char controller  = %d\n",info.controller );
 printf("     char wifi        = %d\n",info.wifi       );
 printf("     char bluetooth   = %d\n",info.bluetooth  );

 // CM_GET_UP_VERSION - ?

 retval=ioctl(ntx_io, CM_GET_UP_VERSION, &pointer);
 printf("ioctl(ntx_io,CM_GET_UP_VERSION)     = %d; returned %ld\n",retval,pointer);


 // CM_nLED - switch on LED

 value=0;
 retval=ioctl(ntx_io, CM_nLED, value);
 printf("ioctl(ntx_io,CM_nLED, %ld) = %d\n",value,retval);

 sleep(3);

 value=1;
 retval=ioctl(ntx_io, CM_nLED, value);
 printf("ioctl(ntx_io,CM_nLED, %ld) = %d\n",value,retval);

 sleep(3);


 // CM_LED_BLINK - blink LED

 value=2;
 retval=ioctl(ntx_io, CM_LED_BLINK, value);
 printf("ioctl(ntx_io,CM_LED_BLINK, %ld) = %d\n",value,retval);

 sleep(3);

 value=1;
 retval=ioctl(ntx_io, CM_LED_BLINK, value);
 printf("ioctl(ntx_io,CM_LED_BLINK, %ld) = %d\n",value,retval);

 sleep(3);

 value=0;
 retval=ioctl(ntx_io, CM_LED_BLINK, value);
 printf("ioctl(ntx_io,CM_LED_BLINK, %ld) = %d\n",value,retval);


 close(ntx_io);
}
