#!/bin/ash

# this script modifies 4 parameters in global.cfg file of PocketBook 622 Touch
# named GammaLevel for Adobe and Min and MaxContrastLevel for DjVu viewer introduced 
# with the firmware 4.2 of this device
# by Paolo see http://www.mobileread.com/forums/showthread.php?t=221829

# until fw 4.4.444 there was 6 parameters (gamma min/max contrast) so here comments are retained for future use
# now Abobe has only gamma setting that can even be modified via PB settings; I leave it here for comfort


SH_IVTOOL=/mnt/ext1/system/bin/sh_ivtool.app

# sh_ivtool.app is developed by Rob Komar's Crappola (alias rkomar); see http://www3.telus.net/rkomar/
# is a tool to interact with a script on PocketBook device; see sh_ivtool syntax for use of -o, -s, -q, -t

menu() { 
	
	# get settings (CFG) for (G)amma (m)in/(M)ax Contrast for (A)dobe and (D)jVu

	CFGGA=`cat /mnt/ext1/system/config/global.cfg | grep GammaLevelAdobe | sed "s/GammaLevelAdobe=//"`
	#CFGmA=`cat /mnt/ext1/system/config/global.cfg | grep MinContrastLevelAdobe | sed "s/MinContrastLevelAdobe=//"`
	#CFGMA=`cat /mnt/ext1/system/config/global.cfg | grep MaxContrastLevelAdobe | sed "s/MaxContrastLevelAdobe=//"`
	CFGGD=`cat /mnt/ext1/system/config/global.cfg | grep GammaLevelDjVu | sed "s/GammaLevelDjVu=//"`
	CFGmD=`cat /mnt/ext1/system/config/global.cfg | grep MinContrastLevelDjVu | sed "s/MinContrastLevelDjVu=//"`
	CFGMD=`cat /mnt/ext1/system/config/global.cfg | grep MaxContrastLevelDjVu | sed "s/MaxContrastLevelDjVu=//"`
	
	# ask with sh_ivtool what to do
	
	#PRG=`$SH_IVTOOL -o "Adobe Γ $CFGGA C $CFGmA-$CFGMA","DjVu Γ $CFGGD C $CFGmD-$CFGMD","Restore to default 2.5/0/100","Read Adobe and DjVu parameters","Backup global.cfg",About,QUIT`
	PRG=`$SH_IVTOOL -o "Adobe Γ $CFGGA","DjVu Γ $CFGGD C $CFGmD-$CFGMD","Restore to default 2.5/0/100","Read Adobe and DjVu parameters","Backup global.cfg",About,QUIT`
	#if [ $? -eq 0 -a "$PRG" == "Adobe Γ $CFGGA C $CFGmA-$CFGMA" ]; then
	if [ $? -eq 0 -a "$PRG" == "Adobe Γ $CFGGA" ]; then
	adobe
	fi
	
	if [ $? -eq 0 -a "$PRG" == "DjVu Γ $CFGGD C $CFGmD-$CFGMD" ]; then
	djvu
	fi

	if [ $? -eq 0 -a "$PRG" == "Restore to default 2.5/0/100" ]; then
	restore
	fi
	
	if [ $? -eq 0 -a "$PRG" == "Read Adobe and DjVu parameters" ]; then
	readall
	fi

	if [ $? -eq 0 -a "$PRG" == "Backup global.cfg" ]; then
	backup
	fi

	if [ $? -eq 0 -a "$PRG" == "About" ]; then
	about
	fi

	if [ $? -eq 0 -a "$PRG" == "QUIT" ]; then
	exit
	fi
	}

adobe() { 
	
	# ask with sh_ivtool new parameters and apply them if non empty
		
	#NEW=`$SH_IVTOOL -t "$PRG. New Γ/mC/MC:"`
	NEW=`$SH_IVTOOL -t "$PRG. New Γ:"`
	if [ $? -eq 0 -a "$NEW" == "q" ]; then
		menu 
	else
		#NEWG=`echo $NEW | cut -d '/' -f 1`
		#NEWm=`echo $NEW | cut -d '/' -f 2`
		#NEWM=`echo $NEW | cut -d '/' -f 3`
		#if [ ! -z "$NEWG" ]; then
		#	sed -i "s/GammaLevelAdobe=.*/GammaLevelAdobe="$NEWG"/" /mnt/ext1/system/config/global.cfg 
		#	fi	
		#if [ ! -z "$NEWm" ]; then 
		#	sed -i "s/MinContrastLevelAdobe=.*/MinContrastLevelAdobe="$NEWm"/" /mnt/ext1/system/config/global.cfg
		#	fi	
		#if [ ! -z "$NEWM" ]; then
		#	sed -i "s/MaxContrastLevelAdobe=.*/MaxContrastLevelAdobe="$NEWM"/" /mnt/ext1/system/config/global.cfg 
		#	fi	
		
		sed -i "s/GammaLevelAdobe=.*/GammaLevelAdobe="$NEW"/" /mnt/ext1/system/config/global.cfg 
		
		menu
	fi
	}
	
djvu() { 

	# ask with sh_ivtool new parameters and apply them if non empty
		
	NEW=`$SH_IVTOOL -t "$PRG. New Γ/mC/MC:"`
	if [ $? -eq 0 -a "$NEW" == "q" ]; then
		menu
	else
		NEWG=`echo $NEW | cut -d '/' -f 1`
		NEWm=`echo $NEW | cut -d '/' -f 2`
		NEWM=`echo $NEW | cut -d '/' -f 3`
		if [ ! -z "$NEWG" ]; then 
			sed -i "s/GammaLevelDjVu=.*/GammaLevelDjVu="$NEWG"/" /mnt/ext1/system/config/global.cfg 
			fi	
		if [ ! -z "$NEWm" ]; then 
			sed -i "s/MinContrastLevelDjVu=.*/MinContrastLevelDjVu="$NEWm"/" /mnt/ext1/system/config/global.cfg 
			fi	
		if [ ! -z "$NEWM" ]; then 
			sed -i "s/MaxContrastLevelDjVu=.*/MaxContrastLevelDjVu="$NEWM"/" /mnt/ext1/system/config/global.cfg 
			fi	
		menu
	fi
	}
	
restore() { 

	# restore all parameters to 2.5 Gamma 0 min 100 max Contrast
	
	sed -i "s/GammaLevelAdobe=.*/GammaLevelAdobe=2.5/" /mnt/ext1/system/config/global.cfg
	#sed -i "s/MinContrastLevelAdobe=.*/MinContrastLevelAdobe=0/" /mnt/ext1/system/config/global.cfg	
	#sed -i "s/MaxContrastLevelAdobe=.*/MaxContrastLevelAdobe=100/" /mnt/ext1/system/config/global.cfg	
	sed -i "s/GammaLevelDjVu=.*/GammaLevelDjVu=2.5/" /mnt/ext1/system/config/global.cfg
	sed -i "s/MinContrastLevelDjVu=.*/MinContrastLevelDjVu=0/" /mnt/ext1/system/config/global.cfg	
	sed -i "s/MaxContrastLevelDjVu=.*/MaxContrastLevelDjVu=100/" /mnt/ext1/system/config/global.cfg	
	STATE="Restored to default"
	menu

	}
	
readall() { 

	# read and show settings

	$SH_IVTOOL -s "Gamma and Contrast settings for Adobe and DjVu:
	
	`cat /mnt/ext1/system/config/global.cfg | grep Adobe`
	
	`cat /mnt/ext1/system/config/global.cfg | grep DjVu`"
	
	menu
	
	}

backup() {

	# copy global.cfg file and show this
	
	cp /mnt/ext1/system/config/global.cfg /mnt/ext1/system/config/global.cfg.old
	$SH_IVTOOL -s "global.cfg.old written to
	/mnt/ext1/system/config/"
	
	menu
	
	}

about() { 

	# little help 
	
	$SH_IVTOOL -s "Change Gamma or Contrast settings for Adobe and DjVu reader (by Paolo)

Input 
Gamma (Γ) in the format 'x.x' (with dot; more decimals are accepted but don't add more benefit).
Contrast (C) min(m)/Max(M) as integer.
Values for DjVu Γ/C(m)/C(M) separetad by '/' (slash) without blank spaces.
Is accepted *ANY* value/char but:
'q' quit without changes;
'no char' doesn't change that parameter;
*** WARNING! ***
Except these, no tests on the input are performed!

Examples for DjVu:
2.5/10/90 three parameters
0.5//     only Γ
/10/90    only C min/Max
//90      only C Max
//        like q"
	
	menu
	
	}

menu

exit

