/*
 * Decompiled with CFR 0.152.
 */
package org.echolink.proxy;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.echolink.proxy.ELProxy;

public class StatusPoster
extends Thread {
    private static final String POSTER_URL = "http://www.echolink.org/proxypost.jsp";
    private static final int SLEEP_TIME = 600000;
    private static final String SS = "#5A!zu";
    private String m_sName;
    private String m_sComment;
    private boolean m_fPublic;
    private boolean m_fBusy;
    private String m_sBindAddr;
    private String m_sRegAddr;
    private String m_sDigestString;
    private String m_sClientCall;
    private String m_sClientIP;
    private int m_nPortNumber;
    static char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public StatusPoster(String sName, String sComment, boolean fPublic, String sBindAddr, String sRegAddr, int nPort) {
        this.m_sName = sName;
        this.m_sComment = sComment;
        this.m_fPublic = fPublic;
        this.m_fBusy = false;
        this.m_sBindAddr = sBindAddr;
        this.m_sRegAddr = sBindAddr;
        if (sRegAddr != null && !"0.0.0.0".equals(sRegAddr)) {
            this.m_sRegAddr = sRegAddr;
        }
        this.m_sClientCall = null;
        this.m_sClientIP = null;
        this.m_nPortNumber = nPort;
    }

    public static String toHexString(byte[] b) {
        StringBuffer sb = new StringBuffer(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            sb.append(hexChar[(b[i] & 0xF0) >>> 4]);
            sb.append(hexChar[b[i] & 0xF]);
        }
        return sb.toString();
    }

    public void run() {
        try {
            MessageDigest cDigest = MessageDigest.getInstance("MD5");
            cDigest.update(this.m_sName.getBytes());
            cDigest.update(this.m_sRegAddr.getBytes());
            cDigest.update(SS.getBytes());
            byte[] bDigest = cDigest.digest();
            this.m_sDigestString = StatusPoster.toHexString(bDigest);
        }
        catch (NoSuchAlgorithmException ea) {
            return;
        }
        while (true) {
            this.postStatus(POSTER_URL, this.m_sName, this.m_sComment, this.m_fPublic, this.m_fBusy, true, this.m_sClientCall, this.m_sClientIP);
            try {
                Thread.sleep(600000L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    public void setStatus(boolean fBusy, String sClientCall, String sClientIP) {
        this.m_fBusy = fBusy;
        this.m_sClientCall = sClientCall;
        this.m_sClientIP = sClientIP;
        this.postStatus(POSTER_URL, this.m_sName, this.m_sComment, this.m_fPublic, this.m_fBusy, true, this.m_sClientCall, this.m_sClientIP);
    }

    public void postShutdown() {
        this.postStatus(POSTER_URL, this.m_sName, this.m_sComment, this.m_fPublic, false, false, null, null);
    }

    private void postStatus(String sURL, String sName, String sComment, boolean fPublic, boolean fBusy, boolean fOnline, String sClientCall, String sClientIP) {
        URL u = null;
        try {
            u = new URL(sURL);
        }
        catch (MalformedURLException ex) {
            System.out.println("Bad status post URL: " + ex.toString());
        }
        try {
            HttpURLConnection conn = (HttpURLConnection)u.openConnection();
            conn.setUseCaches(false);
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream(512);
            PrintWriter out = new PrintWriter(byteStream, true);
            String sPublic = "N";
            if (fPublic) {
                sPublic = "Y";
            }
            String sStatus = "Ready";
            if (fBusy) {
                sStatus = "Busy";
            }
            if (!fOnline) {
                sStatus = "Off";
            }
            String postData = "name=" + URLEncoder.encode(sName, "UTF-8") + "&comment=" + URLEncoder.encode(sComment, "UTF-8") + "&public=" + sPublic + "&status=" + sStatus + "&a=" + this.m_sRegAddr + "&d=" + this.m_sDigestString + "&p=" + this.m_nPortNumber + "&v=" + "1.2.3";
            if (sClientCall != null && sClientIP != null) {
                postData = postData + "&cc=" + URLEncoder.encode(sClientCall, "UTF-8") + "&ca=" + URLEncoder.encode(sClientIP, "UTF-8");
            }
            out.print(postData);
            out.flush();
            String lengthString = String.valueOf(byteStream.size());
            conn.setRequestProperty("Content-Length", lengthString);
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            byteStream.writeTo(conn.getOutputStream());
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while (in.readLine() != null) {
            }
        }
        catch (IOException e) {
            ELProxy.traceMsg("Cannot post registration message: " + e.getMessage());
        }
    }
}

