/*
 * Decompiled with CFR 0.152.
 */
package org.echolink.proxy;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.Random;
import org.echolink.proxy.ProxyMessage;
import org.echolink.proxy.StatusPoster;
import org.echolink.proxy.TCPListener;
import org.echolink.proxy.UDPListener;

public class ELProxy {
    private int m_nPort;
    private InetAddress m_aInsideBindAddress;
    private InetAddress m_aOutsideBindAddress;
    private String m_sPassword;
    private String m_sRegName;
    private String m_sRegComment;
    private String m_sAllowedPattern;
    private String m_sDeniedPattern;
    private String m_sRegAddress;
    private boolean m_fPublic;
    private int m_nConnectionTimeout = 0;
    private static boolean m_bTrace = false;
    private StatusPoster m_oPoster;
    private static final int RTP_DATA_PORT = 5198;
    private static final int RTP_CONTROL_PORT = 5199;
    private static final int ADDR_SERVER_PORT = 5200;
    private static final int REASON_CODE_BAD_PW = 1;
    private static final int REASON_CODE_ACCESS_DENIED = 2;
    private static final int DEFAULT_PROXY_PORT = 8100;
    private static final int AUTH_SOCKET_TIMEOUT = 30000;
    private static final int CLIENT_SOCKET_TIMEOUT = 600000;
    private static final int ADDR_SOCKET_TIMEOUT = 60000;
    private static final int CONNECT_TIMEOUT = 10000;
    public static final String PROGRAM_VERSION = "1.2.3";
    private static final String DEFAULT_CONFIG_FILENAME = "ELProxy.conf";
    private static final String PUBLIC_PASSWORD = "PUBLIC";

    public ELProxy(Properties p) {
        this.m_nPort = Integer.parseInt(p.getProperty("Port", Integer.toString(8100)));
        try {
            this.m_aInsideBindAddress = InetAddress.getByName(p.getProperty("BindAddress"));
        }
        catch (UnknownHostException e) {
            ELProxy.logMsg("Invalid BindAddress; check configuration file");
            System.exit(-1);
        }
        this.m_aOutsideBindAddress = this.m_aInsideBindAddress;
        String sExtBind = p.getProperty("ExternalBindAddress");
        if (sExtBind != null && !"0.0.0.0".equals(sExtBind)) {
            try {
                this.m_aOutsideBindAddress = InetAddress.getByName(p.getProperty("ExternalBindAddress"));
            }
            catch (UnknownHostException e) {
                ELProxy.logMsg("Invalid ExternalBindAddress; check configuration file");
                System.exit(-1);
            }
        }
        this.m_sPassword = p.getProperty("Password");
        this.m_sPassword = this.m_sPassword.toUpperCase();
        this.m_sRegName = p.getProperty("RegistrationName");
        this.m_sRegComment = p.getProperty("RegistrationComment", "");
        this.m_sRegAddress = p.getProperty("PublicAddress", "0.0.0.0");
        this.m_nConnectionTimeout = Integer.parseInt(p.getProperty("ConnectionTimeout", "0"));
        this.m_sDeniedPattern = p.getProperty("CallsignsDenied");
        this.m_sAllowedPattern = p.getProperty("CallsignsAllowed");
        this.m_fPublic = false;
        if (this.m_sPassword.equals(PUBLIC_PASSWORD)) {
            this.m_fPublic = true;
        }
    }

    public void run() {
        String sInsideAddr = this.m_aInsideBindAddress.getHostAddress();
        if (sInsideAddr.equals("0.0.0.0")) {
            ELProxy.logMsg("Listening for connections on port " + this.m_nPort);
        } else {
            ELProxy.logMsg("Listening for connections on " + sInsideAddr + ":" + this.m_nPort);
        }
        ServerSocket sListen = null;
        try {
            sListen = new ServerSocket(this.m_nPort, 3, this.m_aInsideBindAddress);
        }
        catch (IOException ex) {
            ELProxy.logMsg("Cannot bind proxy socket: " + ex.toString());
            ELProxy.logMsg("Check to see if another instance of EchoLink Proxy (or some other program) is already using port number " + this.m_nPort + ".");
            return;
        }
        String sOutsideAddr = this.m_aOutsideBindAddress.getHostAddress();
        if (!sOutsideAddr.equals("0.0.0.0")) {
            ELProxy.logMsg("Using " + sOutsideAddr + " for Internet connections");
        }
        DatagramSocket sUDPControl = null;
        DatagramSocket sUDPData = null;
        try {
            if (this.m_aOutsideBindAddress != null) {
                sUDPControl = new DatagramSocket(5199, this.m_aOutsideBindAddress);
                sUDPData = new DatagramSocket(5198, this.m_aOutsideBindAddress);
            } else {
                sUDPControl = new DatagramSocket(5199);
                sUDPData = new DatagramSocket(5198);
            }
        }
        catch (SocketException eUDP) {
            ELProxy.logMsg("Datagram socket setup failed: " + eUDP.toString());
            ELProxy.logMsg("Check to see if another instance of EchoLink Proxy (or Echolink) is already running.");
            if (sUDPControl != null) {
                sUDPControl.close();
            }
            if (sUDPData != null) {
                sUDPData.close();
            }
            return;
        }
        UDPListener cUDPControlListener = new UDPListener(6, sUDPControl);
        cUDPControlListener.setDaemon(true);
        cUDPControlListener.start();
        UDPListener cUDPDataListener = new UDPListener(5, sUDPData);
        cUDPDataListener.setDaemon(true);
        cUDPDataListener.start();
        if (this.m_sRegName != null && this.m_sRegName.length() != 0) {
            ELProxy.logMsg("Posting registration info to EchoLink Web site");
            this.m_oPoster = new StatusPoster(this.m_sRegName, this.m_sRegComment, this.m_fPublic, sOutsideAddr, this.m_sRegAddress, this.m_nPort);
            this.m_oPoster.start();
        }
        if (this.m_nConnectionTimeout != 0) {
            ELProxy.logMsg("Connection timeout: " + this.m_nConnectionTimeout + " minutes");
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                System.out.println("Shutting down...");
                if (ELProxy.this.m_oPoster != null) {
                    ELProxy.this.m_oPoster.postShutdown();
                }
            }
        });
        while (true) {
            byte[] bReasonCode;
            String sCallsign;
            Socket sAccept;
            block76: {
                sAccept = null;
                try {
                    ELProxy.logMsg("Ready for new client connection.");
                    sAccept = sListen.accept();
                }
                catch (IOException ex1) {
                    ELProxy.logMsg("Socket accept() failed: " + ex1.toString());
                    return;
                }
                ELProxy.logMsg("Client connected: " + sAccept.getInetAddress().getHostAddress());
                try {
                    sAccept.setSoTimeout(30000);
                }
                catch (SocketException eto) {
                    // empty catch block
                }
                Random cRand = new Random(System.currentTimeMillis());
                String sNonce = Integer.toHexString(cRand.nextInt());
                while (sNonce.length() < 8) {
                    sNonce = sNonce + "=";
                }
                byte[] bDigest = null;
                try {
                    MessageDigest cDigest = MessageDigest.getInstance("MD5");
                    cDigest.update(this.m_sPassword.getBytes());
                    cDigest.update(sNonce.getBytes());
                    bDigest = cDigest.digest();
                }
                catch (NoSuchAlgorithmException ea) {
                    ELProxy.logMsg("Internal error: cannot load message digest algorithm");
                    return;
                }
                sCallsign = "";
                try {
                    byte b;
                    InputStream stmIn = sAccept.getInputStream();
                    OutputStream stmOut = sAccept.getOutputStream();
                    stmOut.write(sNonce.getBytes());
                    while (sCallsign.length() < 12 && (b = (byte)stmIn.read()) != 10 && b != -1) {
                        sCallsign = sCallsign + (char)b;
                    }
                    byte[] bReceivedDigest = new byte[bDigest.length];
                    int nOffset = 0;
                    int nLen = bDigest.length;
                    while (nOffset < bDigest.length) {
                        int nRead = stmIn.read(bReceivedDigest, nOffset, nLen);
                        if (nRead < 0) {
                            throw new IOException("Socket closed");
                        }
                        nOffset += nRead;
                        nLen -= nRead;
                    }
                    int nNext = stmIn.available();
                    for (int i = 0; i < bDigest.length; ++i) {
                        if (bReceivedDigest[i] == bDigest[i]) continue;
                        bReasonCode = new byte[]{1};
                        ProxyMessage cMsg = new ProxyMessage(7, null, 1, bReasonCode);
                        try {
                            cMsg.writeToSocket(sAccept);
                        }
                        catch (IOException ed) {
                            // empty catch block
                        }
                        throw new IOException("Incorrect password challenge received (call=" + sCallsign + ")");
                    }
                    if (this.checkAccessControls(sCallsign)) break block76;
                    byte[] bReasonCode2 = new byte[]{2};
                    ProxyMessage cMsg = new ProxyMessage(7, null, 1, bReasonCode2);
                    try {
                        cMsg.writeToSocket(sAccept);
                    }
                    catch (IOException ed) {
                        // empty catch block
                    }
                    throw new IOException("Access denied (call=" + sCallsign + ")");
                }
                catch (IOException ex3) {
                    ELProxy.logMsg(ex3.getMessage() + "; client disconnected");
                    try {
                        sAccept.close();
                    }
                    catch (IOException eclose) {
                        ELProxy.logMsg("sAccept.close() failed: " + eclose.toString());
                    }
                    sAccept = null;
                    continue;
                }
            }
            ELProxy.logMsg("Client authenticated (call=" + sCallsign + ").");
            if (this.m_oPoster != null) {
                this.m_oPoster.setStatus(true, sCallsign, sAccept.getInetAddress().getHostAddress());
            }
            try {
                sAccept.setSoTimeout(600000);
            }
            catch (SocketException eto) {
                // empty catch block
            }
            cUDPControlListener.setReplySocket(sAccept);
            cUDPDataListener.setReplySocket(sAccept);
            boolean fSocketsOK = false;
            Socket sTCPClient = null;
            OutputStream stmOut = null;
            DatagramSocket sUDPDataOut = null;
            DatagramSocket sUDPControlOut = null;
            sUDPDataOut = sUDPData;
            sUDPControlOut = sUDPControl;
            fSocketsOK = true;
            Date dClientConnectionStart = new Date();
            block58: while (fSocketsOK) {
                Date dNow;
                ProxyMessage cMsg = null;
                try {
                    cMsg = ProxyMessage.readFromSocket(sAccept);
                }
                catch (IOException eClient) {
                    ELProxy.logMsg("Client disconnected: " + eClient.getMessage());
                    break;
                }
                if (this.m_nConnectionTimeout != 0 && (dNow = new Date()).getTime() - dClientConnectionStart.getTime() > (long)this.m_nConnectionTimeout * 60L * 1000L) {
                    ELProxy.logMsg("Client connected for too long; disconnecting");
                    break;
                }
                switch (cMsg.getType()) {
                    case 1: {
                        ELProxy.traceMsg("PROXY_MSG_TCP_OPEN");
                        try {
                            if (sTCPClient != null) {
                                try {
                                    sTCPClient.close();
                                }
                                catch (IOException e5) {
                                    ELProxy.logMsg("sTCPClient.close() failed: " + e5.toString());
                                }
                            }
                            sTCPClient = new Socket();
                            try {
                                sTCPClient.setSoTimeout(60000);
                            }
                            catch (SocketException eto) {
                                // empty catch block
                            }
                            sTCPClient.bind(new InetSocketAddress(this.m_aOutsideBindAddress, 0));
                            sTCPClient.connect(new InetSocketAddress(cMsg.getAddress(), 5200), 10000);
                            ELProxy.traceMsg("Connect succeeded to " + cMsg.getAddress().getHostAddress());
                            ELProxy.returnTCPError(sAccept, 0);
                            ProxyMessage cStatusMsg = new ProxyMessage(4, null, 0, null);
                            TCPListener cTCPListener = new TCPListener(sAccept, sTCPClient);
                            cTCPListener.setDaemon(true);
                            cTCPListener.start();
                            stmOut = sTCPClient.getOutputStream();
                        }
                        catch (IOException ex2) {
                            ELProxy.logMsg("Connect failed to addressing server at " + cMsg.getAddress().getHostAddress() + ": " + ex2.getMessage());
                            ELProxy.returnTCPError(sAccept, ex2.hashCode());
                        }
                        break;
                    }
                    case 2: {
                        ELProxy.traceMsg("PROXY_MSG_DATA");
                        if (!this.verifyLoginMessage(cMsg.getData())) {
                            bReasonCode = new byte[]{2};
                            cMsg = new ProxyMessage(7, null, 1, bReasonCode);
                            try {
                                cMsg.writeToSocket(sAccept);
                            }
                            catch (IOException ed) {
                                // empty catch block
                            }
                            if (sTCPClient != null) {
                                try {
                                    sTCPClient.close();
                                }
                                catch (IOException e6) {
                                    ELProxy.logMsg("sTCPClient.close() failed: " + e6.toString());
                                }
                                sTCPClient = null;
                            }
                            stmOut = null;
                            break;
                        }
                        try {
                            if (stmOut == null) continue block58;
                            stmOut.write(cMsg.getData());
                        }
                        catch (IOException eOut) {
                            ELProxy.returnTCPError(sAccept, eOut.hashCode());
                            try {
                                sTCPClient.close();
                            }
                            catch (IOException e5) {
                                ELProxy.logMsg("sTCPClient.close() failed: " + e5.toString());
                            }
                            sTCPClient = null;
                            stmOut = null;
                        }
                        break;
                    }
                    case 3: {
                        ELProxy.traceMsg("PROXY_MSG_TCP_CLOSE");
                        if (sTCPClient != null) {
                            try {
                                sTCPClient.close();
                            }
                            catch (IOException e6) {
                                ELProxy.logMsg("sTCPClient.close() failed: " + e6.toString());
                            }
                            sTCPClient = null;
                        }
                        stmOut = null;
                        break;
                    }
                    case 6: {
                        try {
                            sUDPControlOut.send(new DatagramPacket(cMsg.getData(), cMsg.getSize(), cMsg.getAddress(), 5199));
                        }
                        catch (IOException e12) {
                            ELProxy.logMsg("sUDPControlOut.send() failed: " + e12.toString());
                        }
                        break;
                    }
                    case 5: {
                        try {
                            sUDPDataOut.send(new DatagramPacket(cMsg.getData(), cMsg.getSize(), cMsg.getAddress(), 5198));
                            break;
                        }
                        catch (IOException e12) {
                            ELProxy.logMsg("sUDPDataOut.send() failed: " + e12.toString());
                        }
                    }
                }
            }
            cUDPControlListener.setReplySocket(null);
            cUDPDataListener.setReplySocket(null);
            if (sTCPClient != null) {
                try {
                    sTCPClient.close();
                }
                catch (IOException e6) {
                    ELProxy.logMsg("sTCPClient.close() failed: " + e6.toString());
                }
                sTCPClient = null;
            }
            try {
                sAccept.close();
            }
            catch (IOException e7) {
                ELProxy.logMsg("sAccept.close() failed: " + e7.toString());
            }
            sAccept = null;
            if (this.m_oPoster == null) continue;
            this.m_oPoster.setStatus(false, null, null);
        }
    }

    private boolean verifyLoginMessage(byte[] data) {
        if (data == null || data.length < 20) {
            return true;
        }
        for (int i = 1; i < 19; ++i) {
            if (data[i] != -84 || data[i + 1] != -84) continue;
            String sCall = null;
            sCall = data[0] == 108 ? new String(data, 1, i - 1) : new String(data, 0, i);
            if (!this.checkAccessControls(sCall)) {
                ELProxy.logMsg("Access denied (call=" + sCall + ")");
                return false;
            }
            return true;
        }
        return true;
    }

    private boolean checkAccessControls(String sCallsign) {
        if (this.m_sDeniedPattern != null && this.m_sDeniedPattern.length() > 0 && sCallsign.matches(this.m_sDeniedPattern)) {
            return false;
        }
        return this.m_sAllowedPattern == null || this.m_sAllowedPattern.length() <= 0 || sCallsign.matches(this.m_sAllowedPattern);
    }

    public static void showUsage(String sMsg) {
        System.out.println("Error: " + sMsg);
        System.out.println("Command-line arguments:\n");
        System.out.println("  [<configfile>]\n");
        System.out.println("configfile      name of configuration file; optional; default=ELProxy.conf");
    }

    public static void showConfigError(String sMsg) {
        System.out.println("Error: " + sMsg);
        System.out.println("Please check and edit the configuration file.");
    }

    public static void main(String[] sArgs) {
        System.out.println("EchoLink Proxy version 1.2.3");
        String sVer = System.getProperty("java.version");
        if (sVer.startsWith("1.3") || sVer.startsWith("1.2") || sVer.startsWith("1.1") || sVer.startsWith("3.3")) {
            System.err.println("This program requires version 1.4 (or above) of the Java Runtime Environment.");
            System.err.println("Instead, the program was invoked with version " + sVer + ".");
            System.err.println("Please see java.sun.com for the latest versions.");
            return;
        }
        String sConfigFile = DEFAULT_CONFIG_FILENAME;
        if (sArgs.length > 0) {
            sConfigFile = sArgs[0];
        }
        Properties p = new Properties();
        p.setProperty("BindAddress", "0.0.0.0");
        p.setProperty("Port", String.valueOf(8100));
        p.setProperty("Password", "notset");
        try {
            FileInputStream fs = new FileInputStream(sConfigFile);
            p.load(fs);
            fs.close();
        }
        catch (Exception fnfe) {
            ELProxy.showUsage("Missing or unreadable configuration file: " + sConfigFile);
            try {
                File f = new File(DEFAULT_CONFIG_FILENAME);
                if (!f.exists()) {
                    p.store(new FileOutputStream(DEFAULT_CONFIG_FILENAME), "Generated by EchoLink Proxy");
                    System.out.println("Created new configuration file: ELProxy.conf");
                }
            }
            catch (Exception fose) {
                // empty catch block
            }
            return;
        }
        String sPassword = p.getProperty("Password");
        if (sPassword.length() == 0 || sPassword.equals("notset")) {
            ELProxy.showConfigError("Missing password");
            return;
        }
        int nPort = Integer.parseInt(p.getProperty("Port", String.valueOf(8100)));
        String sBindAddress = p.getProperty("BindAddress", "0.0.0.0");
        InetAddress aBindAddress = null;
        try {
            aBindAddress = InetAddress.getByName(sBindAddress);
        }
        catch (UnknownHostException e) {
            ELProxy.showUsage("Invalid bind address: " + sBindAddress + " [" + e.toString() + "]");
            return;
        }
        ELProxy cProxy = new ELProxy(p);
        cProxy.run();
    }

    public static void traceMsg(String sMsg) {
        if (m_bTrace) {
            ELProxy.logMsg(sMsg);
        }
    }

    public static void logMsg(String sMsg) {
        System.out.println(sMsg);
        try {
            String sFilename = "ELProxy.log";
            PrintStream stmLog = new PrintStream(new FileOutputStream(sFilename, true), true);
            String sFormat = "yyyy.MM.dd HH:mm:ss z";
            String sDateTime = new SimpleDateFormat(sFormat).format(new Date());
            stmLog.println(sDateTime + " " + sMsg);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void returnTCPError(Socket s, int rc) {
        byte[] bData = new byte[4];
        ByteBuffer bb = ByteBuffer.wrap(bData);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putInt(rc);
        ProxyMessage cMsg = new ProxyMessage(4, null, 4, bData);
        try {
            cMsg.writeToSocket(s);
        }
        catch (Exception ex) {
            ELProxy.logMsg("returnTCPError() to client failed: " + ex.toString());
        }
    }
}

