import os
import sys
import re
from subprocess import call

# text goes from (0,0) to (46,41)

class KindleEIPS(object):
    def __init__(self, terminal=False):
        self.toTerminal = terminal
        self.abs_maxx = 46
        self.abs_maxy = 40
        # set the defaults
        self.left = 2
        self.top = 2
        self.right = 40
        self.bottom = 39
        self.lasty = self.top
        self.lastx = self.left
	
    def save_framebuffer(self):
        if self.toTerminal:
            print "**Save the framebuffer for future exit"
        else:
            os.system('dd if=/dev/fb0 bs=758 count=1024 > /mnt/us/fb0.raw')

    def restore_framebuffer(self):
        if self.toTerminal:
            print "**Restore the framebuffer to indicate process complete"
        else:
            os.system('cat /mnt/us/fb0.raw > /dev/fb0')
            os.system('eips -g . > /dev/null')
            
    def clear_framebuffer(self):
        if self.toTerminal:
            print "**Delete old framebuffer file"
        else:
            os.remove('/mnt/us/fb0.raw')

    def update_screen(self):
        if self.toTerminal:
            call(['clear'])
        else:
            call(['eips', ''])

    # print text to screen
    def puts(self, text, x, y, hl=False):
        if self.toTerminal:
            print text
        else:
            if x > self.abs_maxx:
                raise "X " + x + " exceeds screen dimension"
            if y > self.abs_maxy:
                raise "Y " + y + " exceeds screen dimension"
            call(['eips', str(x), str(y), text])

    def println(self, text=None, x=-1, y=-1, nobreak=False, hl=False):
        if x < 0:
            x = self.lastx
        if y < 0:
            y = self.lasty

        # allow debugging
        if self.toTerminal:
            if not text:
                print ""
            else:
                print text
            return
                    

        if not text:
            self.lasty = y+1
            return

	text = re.sub("\t", "    ", text) 
        lines = text.splitlines()
        maxlength = self.right - x

        last_strlen = 0
        for textline in lines:
            sublines = [ textline[i:i+maxlength] for i in range(0, len(textline), maxlength) ]
            for printline in sublines:
                self.puts(printline, x, y)
                y += 1
                last_strlen = len(printline)

        if not nobreak:
            self.lasty = y
            self.lastx = x
        else:
            self.lasty = y - 1 # set the index to the current line.
            self.lastx += last_strlen
            
    def display_png(self, imgpath, waveform=False, x=False, y=False):
        if self.toTerminal:
            print "Display image " + imgpath + " to screen"
            return

        params = ['eips', '-g', imgpath]
        if wf:
            params.append('-wf', wf)
        if x:
            params.append('-x', x)
        if y:
            params.append('-y', y)
        call(params)


    def display_bitmap(self, imgpath, waveform=False, x=False, y=False):
        if self.toTerminal:
            print "Display image " + imgpath + " to screen"
            return

        params = ['eips', '-b', imgpath]
        if wf:
            params.append('-wf', wf)
        if x:
            params.append('-x', x)
        if y:
            params.append('-y', y)
        call(params)

    def clear(self):
        if self.toTerminal:
            call(['clear'])
        else:
            call(['eips', '-c'])
