#!/usr/bin/env python
import os
import sys
import time
import optparse
import subprocess
import re

#INSTALL_REQUIRES.append('urllib3')  # This is a 3rd party connections lib for 2.6+
from KindleEIPS import KindleEIPS

#Parse some parameters
parser = optparse.OptionParser()
parser.set_defaults(terminal=False)
parser.add_option('--terminal', action='store_true', dest='terminal')
(options, args) = parser.parse_args()

# Create our IO object
eips = KindleEIPS(terminal=options.terminal)
eips.save_framebuffer()
eips.clear()

eips.println('IP Address Display', x=15, y=10)
eips.println()

# here we will do initial startup sometime - getting the key, creating directories
proc = subprocess.Popen(["ifconfig | grep inet | sed -re \'s/^\s*//\'"], 
                        stdout=subprocess.PIPE, 
                        shell=True)
(out, err) = proc.communicate()
outlines = out.splitlines()
for line in outlines:
    addr = re.search('addr\s*\:\s*(\d+\.\d+\.\d+\.\d+)', line)
    if addr and addr.group(0) and not re.search('127.0.0.1', line):
        eips.println("IP Address Found")
        eips.println(addr.group(0))
        eips.println()

eips.println("...finished", x=25)        
time.sleep(5)
eips.restore_framebuffer()
eips.clear_framebuffer()

#print "Kbox made!", kbox.account_info
#print "Folder!", json.dumps(kbox.folder_metadata, sort_keys=True, indent=4, separators=(',', ': '))



        

