//C- -------------------------------------------------------------------
//C- This code was heavily derived from Java DjVu (r) (v. 0.8)
//C- Copyright (c) 2004-2005 LizardTech, Inc.  All Rights Reserved.
//C- Java DjVu is protected by U.S. Pat. No.C- 6,058,214 and patents
//C- pending.
//C-
//C- Portions of this code pertaining to operation of the code on the
//C- iRex iLiad are Copyright (c) 2007 Scott Turner scotty1024@mac.com
//C- All Rights Reserved.
//C-
//C- This software is subject to, and may be distributed under, the
//C- GNU General Public License, Version 2. The license should have
//C- accompanied the software or you may obtain a copy of the license
//C- from the Free Software Foundation at http://www.fsf.org .
//C-
//C- The computer code originally released by LizardTech under this
//C- license and unmodified by other parties is deemed "the LIZARDTECH
//C- ORIGINAL CODE."  Subject to any third party intellectual property
//C- claims, LizardTech grants recipient a worldwide, royalty-free,
//C- non-exclusive license to make, use, sell, or otherwise dispose of
//C- the LIZARDTECH ORIGINAL CODE or of programs derived from the
//C- LIZARDTECH ORIGINAL CODE in compliance with the terms of the GNU
//C- General Public License.   This grant only confers the right to
//C- infringe patent claims underlying the LIZARDTECH ORIGINAL CODE to
//C- the extent such infringement is reasonably necessary to enable
//C- recipient to make, have made, practice, sell, or otherwise dispose
//C- of the LIZARDTECH ORIGINAL CODE (or portions thereof) and not to
//C- any greater extent that may be necessary to utilize further
//C- modifications or combinations.
//C-
//C- The LIZARDTECH ORIGINAL CODE is provided "AS IS" WITHOUT WARRANTY
//C- OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
//C- TO ANY WARRANTY OF NON-INFRINGEMENT, OR ANY IMPLIED WARRANTY OF
//C- MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
//C-
//C- In addition, as a special exception, LizardTech Inc. gives permission
//C- to link the code of this program with the proprietary Java
//C- implementation provided by Sun (or other vendors as well), and
//C- distribute linked combinations including the two. You must obey the
//C- GNU General Public License in all respects for all of the code used
//C- other than the proprietary Java implementation. If you modify this
//C- file, you may extend this exception to your version of the file, but
//C- you are not obligated to do so. If you do not wish to do so, delete
//C- this exception statement from your version.
//C- -------------------------------------------------------------------
//C- Developed by Bill C. Riemers, Foxtrot Technologies Inc. as work for
//C- hire under US copyright laws.
//C- -------------------------------------------------------------------
//
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.awt.MediaTracker;
import java.awt.Scrollbar;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.Thread;
import java.net.DatagramPacket;
import java.net.MalformedURLException;
import java.net.URL;

import com.lizardtech.djvu.Document;
import com.lizardtech.djvubean.DjVuBean;
import com.lizardtech.djvubean.DjVuImage;
import com.lizardtech.djvubean.DjVuViewport;

import com.irex.sdk.DisplayUpdate;
import com.irex.sdk.ErIpcCmd;
import com.irex.sdk.ErIpcServer;
import com.irex.sdk.ErPageBar;
import com.irex.sdk.IpcServerCallBack;
import com.irex.sdk.ViewerSignal;
import com.irex.sdk.ErBusy;

public class Viewer extends Frame implements PropertyChangeListener, IpcServerCallBack, KeyListener {

    private ErIpcServer m_ersrv;
    private ErPageBar pagebar;
    private int IREX_READER_UA_ID = 110;

    /** Magic scale value used to zoom to fit width. */
    public static final int FIT_WIDTH = -1;

    /** Magic scale value used to zoom to fit page. */
    public static final int FIT_PAGE = -2;

    /** Constant string indicating the image should be displayed. */
    public static final String IMAGE_STRING = "Image";

    /** Constant string indicating the hidden text should be displayed. */
    public static final String TEXT_STRING = "Text";

    /** The cardlayout which displays either the image or the hidden text. */
    public CardLayout cardLayout = null;

    /** This container will contain a scrollable DjVu Image */
    protected Container scrollPane = null;

    /** The current document being displayed. */
    protected Document document = null;
    protected int documentSize = -1;

    /** The current URL being displayed. */
    protected URL url = null;

    /** True until the first time the mouse is moved over the applet. */
    protected boolean first = true;

    /** True if a scrollpane should be used. This is intended for debug purposes. */
    protected boolean useScrollPane = false;

    /** The current zoom factor. */
    protected int     scale     = 100;
    private Component splitPane = null;

    // This container will be the center pane.
    private Container centerPane = null;

    /** The panel which displays the DjVu page. */
    private DjVuBean djvuBean  = null;
    private Object   parentRef = null;
    private boolean  validDjVu = false;

    public static void main(String[] args) {
	Viewer viewer = new Viewer(args[0]);
    }

    public Viewer(String aFileName) {
	System.out.println("url: " + aFileName);

	try {
	    final long startTime = System.currentTimeMillis();
	    System.out.println(Viewer.class.getName() + " loaded");

	    if (aFileName.startsWith("http://")) {
		url = new URL(aFileName);
	    } else if (aFileName.startsWith("file://")) {
		url = new URL(aFileName);
	    } else {
		url = new URL("file://" + aFileName);
	    }

	    final DjVuBean   djvuBean   = getDjVuBean();

	    // Set Frame size to iLiad application area
	    setSize(768, 935);
 
	    final Dimension screenSize = getToolkit().getScreenSize();
	    djvuBean.addPropertyChangeListener(this);

	    setLayout(new BorderLayout());

	    final Component toolbar = null; // djvuBean.getToolbar();

	    if(toolbar != null) {
		add(toolbar, BorderLayout.NORTH);
	    }

	    documentSize = djvuBean.getDocumentSize();
	    //	    System.out.println("Document Size: " + documentSize);

	    add(getSplitPane(djvuBean.getOutline(), getCenterPane()), BorderLayout.CENTER);

	    final Dimension size = getSize();

	    if(size != null) {
		djvuBean.setTargetWidth(size.width);
	    }

	    validDjVu = true;

	    addWindowListener(new WindowAdapter() {
		    public void windowClosing(WindowEvent e) {
			System.out.println("Program closing.");
			System.exit(0);
		    }
		});

	    m_ersrv = ErIpcServer.getInstanceByChannelId(15, this);
	    if (m_ersrv == null) {
		System.out.print("Opening connection to ErIpcServer failed.");
		throw new Exception("Couldn't connect to ErIpcServer.");
	    }

            m_ersrv.startServer();

	    pagebar = ErPageBar.getInstance();
	    if (pagebar == null) {
		System.out.println("pagebar client create error");
		System.exit(1);
	    } else {
		pagebar.pbReset(IREX_READER_UA_ID);
		pagebar.pbSetPageCount(IREX_READER_UA_ID, documentSize);
		pagebar.pbSetCurrentPage(IREX_READER_UA_ID, 1);
		pagebar.pbRedraw(IREX_READER_UA_ID);
	    }

	    addKeyListener(this);
	    requestFocus();

	    setVisible(true);

	    final long   t = System.currentTimeMillis() - startTime;
	    final String d = "000" + t;
	    System.out.println("Viewer initialized in " + (t / 1000L) + "."
			       + d.substring(d.length() - 3) + " seconds");

	} catch(Throwable exp) {
	    validDjVu = false;
	    removeAll();
	    exp.printStackTrace();
	}

	//runnable.parentRef = DjVuObject.createWeakReference(this, this);
	//new Thread(this).start();
    }

    /**
     * Query and/or create the DjVuBean being displayed.
     *
     * @return the DjVuBean.
     *
     * @throws IOException if an error occures decoding the document
     */
    public DjVuBean getDjVuBean()
	throws IOException
    {
	DjVuBean retval = djvuBean;

	if(retval == null) {
	    try {
		retval = djvuBean = new DjVuBean(); // new DjVuViewport());
		retval.setURL(url);
	    } catch (Throwable t) {
		System.out.println("Failed to setURL");
		t.printStackTrace();
		System.exit(1);
	    }
	}

	return retval;
    }

    /**
     * Query and/or create the component to use as scroll pane by the DjVuBean.
     *
     * @return the component to use as a scroll pane.
     *
     * @throws IOException if an error occures decoding the document
     */
    public Component getScrollPane()
	throws IOException
    {
	Container retval = scrollPane;

	if(retval == null) {
	    final DjVuBean page = getDjVuBean();

	    if (page instanceof DjVuViewport) {
		//retval = new Panel();
		retval = new Container();
		retval.setLayout(new BorderLayout());
		retval.add( "East", ((DjVuViewport)page).getScrollbar(Scrollbar.VERTICAL));
		retval.add( "South", ((DjVuViewport)page).getScrollbar(Scrollbar.HORIZONTAL));
		retval.add( "Center", page);
	    } else {
		/*
		retval = scrollPane = new ScrollPane();
		retval.setBackground(new Color(128, 128, 128));
		retval.add(page);
		*/
		page.setBackground(new Color(128, 128, 128));
		return page;
	    }
	}

	return retval;
    }

    /**
     * Called to create a split pane for displaying outline navigation along
     * side of the DjVuBean.
     *
     * @param leftPane outline navigation.
     * @param centerPane DjVuBean.
     *
     * @return the component to display.
     */
    public Component getSplitPane(final Component leftPane,
				  final Component centerPane)
    {
	if (leftPane == null) {
	    return centerPane;
	}

	if (centerPane == null) {
	    return leftPane;
	}

	//	Container retval = new Panel(new BorderLayout());
	Container retval = new Container();
	retval.setLayout(new BorderLayout());
	retval.add(leftPane, BorderLayout.WEST);
	retval.add(centerPane, BorderLayout.CENTER);

	return retval;
    }

    /**
     * Query and/or create the center pane.
     *
     * @return the center pane.
     *
     * @throws IOException if an error occures decoding the document
     */
    public Container getCenterPane()
	throws IOException
    {
	Container retval = centerPane;

	if (retval == null) {
	    synchronized(this) {
		retval = centerPane;

		if (retval == null) {
		    //		    retval = new Panel();
		    retval = new Container();
		    retval.setBackground(new Color(128, 128, 128));

		    final CardLayout cardLayout = new CardLayout();
		    retval.setLayout(cardLayout);
		    retval.add(IMAGE_STRING,
			       getScrollPane());
		    /*
		    retval.add(TEXT_STRING,
			       getDjVuBean().getTextArea());
		    */
		    centerPane        = retval;
		    this.cardLayout   = cardLayout;
		}
	    }
	}

	return retval;
    }

    /**
     * Called when a DjVuBean propery has changed.
     *
     * @param event describing the property change.
     */
    public void propertyChange(final PropertyChangeEvent event) {
	    /*
	try {
	    final String name = event.getPropertyName();
	    //System.out.println("propertyChange: " + name + " to: " + event.getNewValue());
	    if("status".equalsIgnoreCase(name)) {
		final Object value=event.getNewValue();
		System.out.println("Status: " + ((value != null)?value.toString():"null"));
	    } else if("mode".equalsIgnoreCase(name)) {
		switch(((Number)event.getNewValue()).intValue()) {
		case DjVuBean.TEXT_MODE :
		    {
			getDjVuBean().getTextArea();
			getCardLayout().show(
					     getCenterPane(),
					     TEXT_STRING);

			break;
		    }
		default :
		    {
			getCardLayout().show(
					     getCenterPane(),
					     IMAGE_STRING);

			break;
		    }
		}
	    } else if("page".equalsIgnoreCase(name)) {
		final Object object = event.getNewValue();

		System.out.println("Page " + object);

		final DjVuBean djvuBean = getDjVuBean();

		if(djvuBean.getMode() == DjVuBean.TEXT_MODE) {
		    getDjVuBean().getTextArea();
		}
	    } else if("submit".equalsIgnoreCase(name)) {
		Object object = event.getNewValue();

		System.out.println("Submit " + object);

		if(object instanceof String) {
		    getAppletContext().showDocument(
						    new URL(
							    getURL(),
							    (String)object),
						    Integer.toString(object.hashCode()));
		} else if(object instanceof URL) {
		    getAppletContext().showDocument(
						    (URL)object,
						    Integer.toString(object.hashCode()));
		} else if(object instanceof Number) {
		    getDjVuBean().setPage(((Number)object).intValue());
		}
		else if(object instanceof Hyperlink) {
		    Hyperlink rect = (Hyperlink)object;

		    // System.out.println("submit "+rect.getURL());
		    final String url = rect.getURL();

		    if((url != null) && (url.length() > 0)) {
			final String target = rect.getTarget();

			if(target != null) {
			    getAppletContext().showDocument(
							    new URL(
								    getURL(),
								    url),
							    target);
			} else {
			    getAppletContext().showDocument(new URL(
								    getURL(),
								    url));
			}
		    }
		}
	    }
	} catch(final Throwable exp) {
	    exp.printStackTrace();
	}
	    */
    }

    public void messageReceived(DatagramPacket datagrampacket) {
        ErIpcCmd eripccmd = ViewerSignal.parseCommand(new String(datagrampacket.getData(), 0, datagrampacket.getLength()));
        if (eripccmd == null) {
            System.out.print("Invalid ErIpcCmd message.");
            return;
        }

        if (eripccmd.get_cmdcode() == 0) {
            String as[] = eripccmd.get_args();
            int newPage = 0;
	    try {
		newPage = Integer.parseInt(as[1]);
	    } catch (Throwable t) {
		System.out.println("Got invalid ErIpcCmd message argument.");
		return;
	    }

	    ErBusy.getInstance().blink();

	    movePage(newPage);
        } else {
	    System.out.println("Ignore ErIpcCmd message of code: " + eripccmd.get_cmdcode());
	}
    }

    public void keyPressed(KeyEvent keyevent) {
        //System.out.println("keyPressed: code= " + keyevent.getKeyCode());

        switch(keyevent.getKeyCode()) {
        case 116:
	    ErBusy.getInstance().blink();
            System.out.println("VK_F5 Quiting.");
	    System.exit(0);
            break;

        case 36:
            //System.out.println("VK_HOME Goto first page");
	    moveRelativePage(1);
            break;

        case 34:
            //System.out.println("VK_PAGE_DOWN Goto next page");
	    moveRelativePage(1);
            break;

        case 112:
            //System.out.println("VK_F1 Long jump forward.");
	    moveRelativePage(5);
            break;

        case 33:
            //System.out.println("VK_PAGE_UP Goto previous page");
	    moveRelativePage(-1);
            break;

        case 113:
            //System.out.println("VK_F2 Long jump backward.");
	    moveRelativePage(-5);
            break;

        default:
            break;
        }
        keyevent.consume();
    }

    public void keyReleased(KeyEvent keyevent) {
    }

    public void keyTyped(KeyEvent keyevent) {
    }

    protected void moveRelativePage(int delta) {
	try {
	    movePage(getDjVuBean().getPage() + delta);
	} catch (IOException e) {
	    System.out.println("Error trying to set page number.");
	    e.printStackTrace();
	}
    }

    protected void movePage(int newPage) {
	if (newPage < 1) {
	    newPage = 1;
	} else if (newPage > documentSize) {
	    newPage = documentSize;
	}

        // Focus is sometimes lost, make sure we get it back during a page update
        requestFocus();

	try {
	    if (getDjVuBean().getPage() != newPage) {
		ErBusy.getInstance().blink();
		getDjVuBean().setPage(newPage);
		pagebar.pbSetCurrentPage(IREX_READER_UA_ID, newPage);
		pagebar.pbRedraw(IREX_READER_UA_ID);
	    }
	} catch (IOException e) {
	    System.out.println("Error trying to set page number.");
	    e.printStackTrace();
	}
    }

}
