/*
 * Decompiled with CFR 0.152.
 */
package com.lizardtech.djvubean.toolbar;

import com.lizardtech.djvubean.toolbar.ListenerSupport;
import com.lizardtech.djvubean.toolbar.PopupChoice;
import com.lizardtech.djvubean.toolbar.ToggleButton;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.ItemSelectable;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.Hashtable;

public class ComboBox
extends Container
implements ItemSelectable {
    protected final CardLayout cardLayout = new CardLayout();
    protected final Container editContainer = new Panel();
    protected final Hashtable itemMap = new Hashtable();
    protected Object lastSelectedItem = null;
    protected final PopupChoice choice;
    protected final TextField textField = new TextField();
    protected String customText = null;
    protected ToggleButton button;
    private final ListenerSupport itemState = new ListenerSupport(class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = ComboBox.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener);
    private boolean isEditable;
    private boolean isPopupVisible = false;
    static /* synthetic */ Class class$java$awt$event$ItemListener;

    ComboBox(String string, String string2, Object object, Dimension dimension) {
        this.choice = new PopupChoice(this);
        this.enableEvents(512L);
        this.setLayout(this.cardLayout);
        this.textField.setColumns(0);
        this.button = new ToggleButton(string, string2, object, dimension);
        this.button.setBorderType(2);
        this.editContainer.setLayout(new FlowLayout(2, 0, 0));
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.textField, "Center");
        panel.add((Component)this.button, "East");
        this.editContainer.add(panel);
        this.add("Editor", this.editContainer);
        this.add("Choice", this.choice);
        this.showChoice();
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ComboBox.this.showPopup();
            }
        });
    }

    public void setBackground(Color color) {
        this.editContainer.setBackground(color);
        this.button.setBackground(color);
        this.choice.setBackground(color);
        super.setBackground(color);
    }

    public ToggleButton getButton() {
        return this.button;
    }

    public void setEditable(boolean bl) {
        if (bl != this.isEditable()) {
            this.isEditable = bl;
            if (!bl) {
                this.showChoice();
            } else {
                if (this.isPopupVisible()) {
                    this.hidePopup();
                }
                this.showEditor();
            }
        }
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public TextField getEditor() {
        return this.textField;
    }

    public void setEnabled(boolean bl) {
        this.editContainer.setEnabled(bl);
        this.button.setEnabled(bl);
        this.choice.setEnabled(bl);
        this.textField.setEnabled(bl);
        super.setEnabled(bl);
    }

    public void setForeground(Color color) {
        this.editContainer.setForeground(color);
        this.button.setForeground(color);
        this.choice.setForeground(color);
        super.setForeground(color);
    }

    public void setIsPopupVisible(boolean bl) {
        this.isPopupVisible = bl;
    }

    public int getItemCount() {
        return this.choice.getItemCount();
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])this.itemState.getListeners();
    }

    public Hashtable getItemMap() {
        return this.itemMap;
    }

    public boolean isPopupVisible() {
        return this.isPopupVisible;
    }

    public void setScaleFactor(double d) {
        this.button.setScaleFactor(d);
    }

    public double getScaleFactor() {
        return this.button.getScaleFactor();
    }

    public int getSelectedIndex() {
        return this.choice.getSelectedIndex();
    }

    public void setSelectedItem(Object object) {
        if (object != null) {
            String string = this.lastSelectedItem != null ? this.lastSelectedItem.toString() : null;
            String string2 = object.toString();
            if (string2.equals(string)) {
                return;
            }
            if (!this.itemMap.containsKey(string2)) {
                if (!this.isEditable()) {
                    return;
                }
                this.choice.add(string2);
                this.choice.select(string2);
                this.choice.remove(string2);
            }
            this.choice.select(string2);
            if (this.lastSelectedItem != null) {
                this.processEvent(new ItemEvent(this, 701, this.lastSelectedItem, 2));
            }
            this.lastSelectedItem = object;
            this.textField.setText(string2);
            int n = string2.length();
            this.textField.setColumns(n > 4 ? n + 1 : 4);
            this.textField.invalidate();
            this.validate();
            this.processEvent(new ItemEvent(this, 701, object, 1));
        }
    }

    public Object[] getSelectedObjects() {
        Object[] objectArray = this.choice.getSelectedObjects();
        for (int i = 0; i < objectArray.length; ++i) {
            Object v;
            if (!(objectArray[i] instanceof String) || (v = this.itemMap.get(objectArray[i])) == null) continue;
            objectArray[i] = v;
        }
        return this.choice.getSelectedObjects();
    }

    public void addItem(Object object) {
        if (object != null) {
            String string = object.toString();
            if (string.equals(this.customText)) {
                this.itemMap.put(string, object);
                this.choice.add(string);
                this.choice.select(string);
            } else {
                this.itemMap.put(string, object);
                this.choice.add(string);
            }
            if (string != null) {
                this.textField.setColumns(0);
            }
            if (this.textField.getText().length() == 0) {
                this.textField.setText(string);
                int n = string.length();
                this.textField.setColumns(n > 4 ? n + 1 : 4);
            }
        }
    }

    public void addItemListener(ItemListener itemListener) {
        this.itemState.addListener(itemListener);
    }

    public void hidePopup() {
        if (this.isPopupVisible) {
            this.showEditor();
            if (!this.isEditable()) {
                this.showChoice();
            }
        }
    }

    public void processItemEvent(ItemEvent itemEvent) {
        if (this.isEnabled()) {
            this.itemState.fireItemEvent(itemEvent);
        }
    }

    public void removeItem(Object object) {
        if (object != null) {
            String string = object.toString();
            this.itemMap.remove(string);
            this.choice.remove(string);
        }
    }

    public void removeItemListener(ItemListener itemListener) {
        this.itemState.removeListener(itemListener);
    }

    public ItemEvent replaceItemEvent(ItemEvent itemEvent) {
        Object object;
        Object v;
        if (itemEvent != null && (v = this.itemMap.get(object = itemEvent.getItem())) != null && v != object) {
            itemEvent = new ItemEvent((ItemSelectable)itemEvent.getSource(), itemEvent.getID(), v, itemEvent.getStateChange());
        }
        return itemEvent;
    }

    public void showChoice() {
        this.cardLayout.show(this, "Choice");
    }

    public void showEditor() {
        this.cardLayout.show(this, "Editor");
    }

    public void showPopup() {
        if (!this.isPopupVisible()) {
            this.showChoice();
            this.choice.requestFocus();
            this.choice.dispatchEvent(new MouseEvent(this, 501, System.currentTimeMillis() - 10L, 16, this.getSize().width - 10, 10, 1, true));
            this.choice.dispatchEvent(new MouseEvent(this, 502, System.currentTimeMillis() - 10L, 16, this.getSize().width - 10, 10, 1, true));
        }
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

